/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.util;

import cn.lm.mybatis.mapper.entity.EntityTable;
import cn.lm.mybatis.mapper.mapperhelper.EntityHelper;
import cn.lm.mybatis.mapper.util.support.ColumnCache;
import cn.lm.mybatis.mapper.util.support.IdeaProxyLambdaMeta;
import cn.lm.mybatis.mapper.util.support.LambdaMeta;
import cn.lm.mybatis.mapper.util.support.ReflectLambdaMeta;
import cn.lm.mybatis.mapper.util.support.SFunction;
import cn.lm.mybatis.mapper.util.support.SerializedLambda;
import cn.lm.mybatis.mapper.util.support.ShadowLambdaMeta;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LambdaUtils {
    private static final Map<String, Map<String, ColumnCache>> COLUMN_CACHE_MAP = new ConcurrentHashMap<String, Map<String, ColumnCache>>();

    public static <T> LambdaMeta extract(SFunction<T, ?> func) {
        if (func instanceof Proxy) {
            return new IdeaProxyLambdaMeta((Proxy)((Object)func));
        }
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            return new ReflectLambdaMeta((java.lang.invoke.SerializedLambda)method.invoke(func, new Object[0]), func.getClass().getClassLoader());
        }
        catch (Throwable e) {
            return new ShadowLambdaMeta(SerializedLambda.extract(func));
        }
    }

    public static String formatKey(String key) {
        return key.toUpperCase(Locale.ENGLISH);
    }

    public static void installCache(EntityTable tableInfo) {
        COLUMN_CACHE_MAP.put(tableInfo.getName(), LambdaUtils.createColumnCacheMap(tableInfo));
    }

    private static Map<String, ColumnCache> createColumnCacheMap(EntityTable info) {
        HashMap<String, ColumnCache> map = new HashMap<String, ColumnCache>(info.getEntityClassColumns().size());
        info.getEntityClassColumns().forEach(i -> map.put(LambdaUtils.formatKey(i.getProperty()), new ColumnCache(i.getColumn(), i.getColumn(), null)));
        return map;
    }

    public static Map<String, ColumnCache> getColumnMap(Class<?> clazz) {
        return COLUMN_CACHE_MAP.computeIfAbsent(clazz.getName(), key -> {
            EntityTable info = EntityHelper.getEntityTableOrNull(clazz);
            return info == null ? null : LambdaUtils.createColumnCacheMap(info);
        });
    }
}

