/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.session;

import cn.lm.mybatis.mapper.entity.Config;
import cn.lm.mybatis.mapper.mapperhelper.MapperHelper;
import java.util.Properties;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends org.apache.ibatis.session.Configuration {
    private final Logger log = LoggerFactory.getLogger(Configuration.class);
    private MapperHelper mapperHelper;

    public void setMapperHelper(MapperHelper mapperHelper) {
        this.mapperHelper = mapperHelper;
    }

    public void setMapperProperties(Properties properties) {
        if (this.mapperHelper == null) {
            this.mapperHelper = new MapperHelper();
        }
        this.mapperHelper.setProperties(properties);
    }

    public void setConfig(Config config) {
        if (this.mapperHelper == null) {
            this.mapperHelper = new MapperHelper();
        }
        this.mapperHelper.setConfig(config);
    }

    public void addMappedStatement(MappedStatement ms) {
        try {
            super.addMappedStatement(ms);
            if (this.mapperHelper == null) {
                this.mapperHelper = new MapperHelper();
            }
            this.mapperHelper.processMappedStatement(ms);
        }
        catch (IllegalArgumentException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

