/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.provider;

import cn.lm.mybatis.mapper.MapperException;
import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.mapperhelper.EntityHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperTemplate;
import cn.lm.mybatis.mapper.mapperhelper.SelectKeyHelper;
import cn.lm.mybatis.mapper.mapperhelper.SqlHelper;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;

public class SaveProvider
extends MapperTemplate {
    public SaveProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String save(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set columnList = EntityHelper.getPKColumns((Class)entityClass);
        if (columnList.size() == 1) {
            EntityColumn column = (EntityColumn)columnList.iterator().next();
            String id = column.getColumn();
            sql.append("<choose>");
            sql.append("<when test='" + id + "!=null'>");
            sql.append(this.updateById(ms));
            sql.append("</when>");
            sql.append("<otherwise>");
            sql.append(this.insert(ms));
            sql.append("</otherwise>");
            sql.append("</choose>");
            return sql.toString();
        }
        return this.insert(ms);
    }

    public String updateById(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.updateTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(SqlHelper.updateSetColumns((Class)entityClass, null, (boolean)false, (boolean)false));
        sql.append(SqlHelper.wherePKColumns((Class)entityClass, (boolean)true));
        return sql.toString();
    }

    public String insert(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        this.processKey(sql, entityClass, ms, columnList);
        sql.append(SqlHelper.insertIntoTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(SqlHelper.insertColumns((Class)entityClass, (boolean)false, (boolean)false, (boolean)false));
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheNotNull((EntityColumn)column, (String)column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlHelper.getIfNotNull((EntityColumn)column, (String)column.getColumnHolder(null, null, ","), (boolean)this.isNotEmpty()));
            }
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheIsNull((EntityColumn)column, (String)(column.getColumnHolder() + ",")));
                continue;
            }
            sql.append(SqlHelper.getIfIsNull((EntityColumn)column, (String)column.getColumnHolder(null, null, ","), (boolean)this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    private void processKey(StringBuilder sql, Class<?> entityClass, MappedStatement ms, Set<EntityColumn> columnList) {
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (column.isIdentity()) {
                sql.append(SqlHelper.getBindCache((EntityColumn)column));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new MapperException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKeyHelper.newSelectKeyMappedStatement((MappedStatement)ms, (EntityColumn)column, entityClass, (Boolean)this.isBEFORE(), (String)this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (column.getGenIdClass() == null) continue;
            sql.append("<bind name=\"").append(column.getColumn()).append("GenIdBind\" value=\"@cn.lm.mybatis.mapper.genid.GenIdUtil@genId(");
            sql.append("_parameter").append(", '").append(column.getProperty()).append("'");
            sql.append(", @").append(column.getGenIdClass().getName()).append("@class");
            sql.append(", '").append(this.tableName(entityClass)).append("'");
            sql.append(", '").append(column.getColumn()).append("')");
            sql.append("\"/>");
        }
    }
}

