/*
 * Decompiled with CFR 0.152.
 */
package club.javafamily.nf.sms.service;

import club.javafamily.nf.enums.NotifySupportTypeEnum;
import club.javafamily.nf.properties.SmsTemplateInfo;
import club.javafamily.nf.request.sms.SmsRequest;
import club.javafamily.nf.service.NotifyHandler;
import club.javafamily.nf.sms.properties.SmsTencentProperties;
import club.javafamily.utils.common.MessageException;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20190711.SmsClient;
import com.tencentcloudapi.sms.v20190711.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class TencentSmsNotifyHandler
implements NotifyHandler<SmsRequest, SendSmsResponse> {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsNotifyHandler.class);
    private final SmsTencentProperties properties;

    public TencentSmsNotifyHandler(SmsTencentProperties properties) {
        this.properties = properties;
    }

    public SendSmsResponse notify(List<String> phoneNumbers, String ... params) {
        return this.notify("default", phoneNumbers, params == null ? null : Arrays.asList(params));
    }

    public SendSmsResponse notify(List<String> phoneNumbers, List<String> params) {
        return this.notify("default", phoneNumbers, params);
    }

    @Nullable
    public SendSmsResponse notify(String template, List<String> phoneNumbers, String ... params) {
        return this.notify(template, phoneNumbers, params == null ? null : Arrays.asList(params));
    }

    @Nullable
    public SendSmsResponse notify(String template, List<String> phoneNumbers, List<String> params) {
        SmsTemplateInfo templateInfo = this.properties.findConfig(template);
        if (templateInfo == null) {
            throw new MessageException("\u672a\u914d\u7f6e\u6a21\u677f: " + template);
        }
        List receiveUsers = templateInfo.getSafeReceiveUsers();
        if (!CollectionUtils.isEmpty(phoneNumbers)) {
            receiveUsers.addAll(phoneNumbers);
        }
        SmsRequest request = this.properties.buildRequest(template, receiveUsers, params);
        return this.notify(request);
    }

    public NotifySupportTypeEnum selfType() {
        return NotifySupportTypeEnum.SMS_TENCENT;
    }

    @Nullable
    public SendSmsResponse notify(SmsRequest request) {
        String appUrl = request.getEndPoint();
        String sdkAppId = request.getNamespaceId();
        String secretId = request.getSecretId();
        String secretKey = request.getSecretKey();
        SendSmsResponse res = new SendSmsResponse();
        try {
            Credential cred = new Credential(secretId, secretKey);
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setReqMethod("POST");
            httpProfile.setConnTimeout(request.getTimeout().intValue());
            httpProfile.setEndpoint(appUrl);
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setSignMethod("HmacSHA256");
            clientProfile.setHttpProfile(httpProfile);
            SmsClient client = new SmsClient(cred, "ap-shanghai");
            client.setClientProfile(clientProfile);
            SendSmsRequest req = new SendSmsRequest();
            req.setSmsSdkAppid(sdkAppId);
            String sign = this.properties.getSign();
            req.setSign(sign);
            req.setTemplateID(request.getTemplateId());
            String[] params = request.getParams() != null ? request.getParams().toArray(new String[0]) : null;
            req.setTemplateParamSet(params);
            List<String> receiveUsers = request.getSafeReceiveUsers();
            if (CollectionUtils.isEmpty((Collection)receiveUsers)) {
                log.warn("No sms receive users for tencent sms!");
                return null;
            }
            receiveUsers = receiveUsers.stream().map(phone -> phone.startsWith("+") ? phone : "+86" + phone).distinct().collect(Collectors.toList());
            req.setPhoneNumberSet(receiveUsers.toArray(new String[0]));
            res = client.SendSms(req);
        }
        catch (TencentCloudSDKException e) {
            log.error("Send tencent sms failed!", (Throwable)e);
        }
        return res;
    }
}

