/*
 * Decompiled with CFR 0.152.
 */
package club.javafamily.nf.sms.properties;

import club.javafamily.nf.properties.SmsTemplateInfo;
import club.javafamily.nf.request.sms.SmsRequest;
import club.javafamily.utils.common.MessageException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="javafamily.notify.sms.tencent")
public class SmsTencentProperties {
    private String appUrl = "sms.tencentcloudapi.com";
    private String sdkAppId;
    private String secretId;
    private String secretKey;
    private String sign;
    private Integer timeout = 60;
    private Map<String, SmsTemplateInfo> config;

    public SmsTemplateInfo findConfig() {
        return this.findConfig(null);
    }

    public SmsTemplateInfo findConfig(String key) {
        key = Objects.toString(key, "default");
        return this.config.get(key);
    }

    public SmsRequest buildRequest(String template, List<String> receiveUsers, List<String> params) {
        SmsTemplateInfo templateInfo = this.findConfig(template);
        if (templateInfo == null) {
            throw new MessageException("\u672a\u914d\u7f6e\u6a21\u677f: " + template);
        }
        return SmsRequest.builder().endPoint(this.getAppUrl()).namespaceId(this.getSdkAppId()).secretId(this.getSecretId()).secretKey(this.getSecretKey()).templateId(templateInfo.getTemplateId()).sign(this.getSign()).params(params).receiveUsers(receiveUsers).timeout(this.getTimeout()).build();
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public String getSdkAppId() {
        return this.sdkAppId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSign() {
        return this.sign;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Map<String, SmsTemplateInfo> getConfig() {
        return this.config;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public void setSdkAppId(String sdkAppId) {
        this.sdkAppId = sdkAppId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setConfig(Map<String, SmsTemplateInfo> config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsTencentProperties)) {
            return false;
        }
        SmsTencentProperties other = (SmsTencentProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appUrl = this.getAppUrl();
        String other$appUrl = other.getAppUrl();
        if (this$appUrl == null ? other$appUrl != null : !this$appUrl.equals(other$appUrl)) {
            return false;
        }
        String this$sdkAppId = this.getSdkAppId();
        String other$sdkAppId = other.getSdkAppId();
        if (this$sdkAppId == null ? other$sdkAppId != null : !this$sdkAppId.equals(other$sdkAppId)) {
            return false;
        }
        String this$secretId = this.getSecretId();
        String other$secretId = other.getSecretId();
        if (this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Map<String, SmsTemplateInfo> this$config = this.getConfig();
        Map<String, SmsTemplateInfo> other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsTencentProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appUrl = this.getAppUrl();
        result = result * 59 + ($appUrl == null ? 43 : $appUrl.hashCode());
        String $sdkAppId = this.getSdkAppId();
        result = result * 59 + ($sdkAppId == null ? 43 : $sdkAppId.hashCode());
        String $secretId = this.getSecretId();
        result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Map<String, SmsTemplateInfo> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    public String toString() {
        return "SmsTencentProperties(appUrl=" + this.getAppUrl() + ", sdkAppId=" + this.getSdkAppId() + ", secretId=" + this.getSecretId() + ", secretKey=" + this.getSecretKey() + ", sign=" + this.getSign() + ", timeout=" + this.getTimeout() + ", config=" + this.getConfig() + ")";
    }
}

