package club.javafamily.swagger.properties;

/**
 * @author Jack Li
 * @date 2021/7/26 10:39 上午
 * @description
 */

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

@Data
@ConfigurationProperties("javafamily.swagger")
public class SwaggerConfigProperties {

   /**
    * 标题
    **/
   private String title = "";
   /**
    * 描述
    **/
   private String description = "";
   /**
    * 版本
    **/
   private String version = "";
   /**
    * 许可证
    **/
   private String license = "";
   /**
    * 许可证URL
    **/
   private String licenseUrl = "";
   /**
    * 服务条款URL
    **/
   private String termsOfServiceUrl = "";

   /**
    * 忽略的参数类型
    **/
   private List<Class<?>> ignoredParameterTypes = new ArrayList<>();

   private Contact contact = new Contact();

   /**
    * swagger会解析的包路径
    **/
   private String basePackage = "";

   /**
    * swagger会解析的url规则
    **/
   private List<String> basePath = new ArrayList<>();
   /**
    * 在basePath基础上需要排除的url规则
    **/
   private List<String> excludePath = new ArrayList<>();

   /**
    * host信息
    **/
   private String host = "";

   /**
    * 全局参数配置
    **/
   private List<GlobalOperationParameter> globalOperationParameters;

   /**
    * 是否使用默认预定义的响应消息 ，默认 true
    **/
   private Boolean applyDefaultResponseMessages = true;

   /**
    * 全局响应消息
    **/
   private GlobalResponseMessage globalResponseMessage;

   @Data
   @NoArgsConstructor
   public static class GlobalOperationParameter {
      /**
       * 参数名
       **/
      private String name;

      /**
       * 默认值
       */
      private String defaultValue;

      /**
       * 描述信息
       **/
      private String description;

      /**
       * 指定参数类型
       **/
      private String modelRef;

      /**
       * 参数放在哪个地方:header,query,path,formData,cookie,form
       **/
      private String parameterType;

      /**
       * 参数是否必须传
       **/
      private Boolean required;

   }

   @Data
   @NoArgsConstructor
   public static class Contact {

      /**
       * 联系人
       **/
      private String name = "";
      /**
       * 联系人url
       **/
      private String url = "";
      /**
       * 联系人email
       **/
      private String email = "";

   }

   @Data
   @NoArgsConstructor
   public static class GlobalResponseMessage {

      /**
       * POST 响应消息体
       **/
      List<GlobalResponseMessageBody> post = new ArrayList<>();

      /**
       * GET 响应消息体
       **/
      List<GlobalResponseMessageBody> get = new ArrayList<>();

      /**
       * PUT 响应消息体
       **/
      List<GlobalResponseMessageBody> put = new ArrayList<>();

      /**
       * PATCH 响应消息体
       **/
      List<GlobalResponseMessageBody> patch = new ArrayList<>();

      /**
       * DELETE 响应消息体
       **/
      List<GlobalResponseMessageBody> delete = new ArrayList<>();

      /**
       * HEAD 响应消息体
       **/
      List<GlobalResponseMessageBody> head = new ArrayList<>();

      /**
       * OPTIONS 响应消息体
       **/
      List<GlobalResponseMessageBody> options = new ArrayList<>();

      /**
       * TRACE 响应消息体
       **/
      List<GlobalResponseMessageBody> trace = new ArrayList<>();

   }

   @Data
   @NoArgsConstructor
   public static class GlobalResponseMessageBody {

      /**
       * 响应码
       **/
      private String code;

      /**
       * 响应消息
       **/
      private String description;

      private String representation;

      /**
       * 响应体
       **/
      private String modelRef;

   }

}
