/*
 * Decompiled with CFR 0.152.
 */
package com.anywide.dawdler.serverplug.rabbitmq.resource;

import com.anywide.dawdler.core.component.resource.ComponentLifeCycle;
import com.anywide.dawdler.core.order.OrderData;
import com.anywide.dawdler.rabbitmq.consumer.RabbitListenerInit;
import com.anywide.dawdler.rabbitmq.provider.RabbitProviderFactory;
import com.anywide.dawdler.server.context.DawdlerContext;
import com.anywide.dawdler.server.filter.DawdlerFilter;
import com.anywide.dawdler.server.filter.FilterProvider;
import com.anywide.dawdler.server.listener.DawdlerListenerProvider;
import com.anywide.dawdler.server.listener.DawdlerServiceListener;
import java.util.List;

public class RabbitLifeCycle
implements ComponentLifeCycle {
    public void init() throws Exception {
        DawdlerContext dawdlerContext = DawdlerContext.getDawdlerContext();
        FilterProvider filterProvider = (FilterProvider)dawdlerContext.getAttribute((Object)"filterProvider");
        DawdlerListenerProvider dawdlerListenerProvider = (DawdlerListenerProvider)dawdlerContext.getAttribute((Object)"dawdlerListenerProvider");
        this.init(dawdlerListenerProvider.getListeners(), filterProvider.getFilters());
    }

    public void init(List<OrderData<DawdlerServiceListener>> dawdlerServiceListeners, List<OrderData<DawdlerFilter>> dawdlerFilters) throws Exception {
        for (OrderData<DawdlerServiceListener> orderData : dawdlerServiceListeners) {
            DawdlerServiceListener dawdlerServiceListener = (DawdlerServiceListener)orderData.getData();
            RabbitProviderFactory.initField((Object)dawdlerServiceListener, dawdlerServiceListener.getClass());
            RabbitListenerInit.initRabbitListener((Object)dawdlerServiceListener, dawdlerServiceListener.getClass());
        }
        for (OrderData<DawdlerServiceListener> orderData : dawdlerFilters) {
            DawdlerFilter dawdlerFilter = (DawdlerFilter)orderData.getData();
            RabbitProviderFactory.initField((Object)dawdlerFilter, dawdlerFilter.getClass());
            RabbitListenerInit.initRabbitListener((Object)dawdlerFilter, dawdlerFilter.getClass());
        }
    }
}

