/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.mqtt;

import cloud.artik.config.Config;
import cloud.artik.mqtt.ArtikCloudMqttCallback;
import cloud.artik.mqtt.ArtikCloudMqttException;
import cloud.artik.mqtt.MqttSession;
import cloud.artik.mqtt.OperationMode;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MqttTest {
    private String deviceId = null;
    private String deviceToken = null;
    final int waitingTimeInMs = 2000;
    final int qos = 2;
    MqttSession mqttSession = null;
    ArtikCloudMqttCallback callback = new ArtikCloudMqttCallback(){

        public void onFailure(OperationMode opMode, IMqttToken mqttToken, Throwable throwable) {
            System.out.println("ArtikCloudMqttCallback::onFailure is called with Mode " + opMode + "; throwable (" + throwable.toString() + ")");
            Assert.fail();
        }

        public void onSuccess(OperationMode opMode, IMqttToken mqttToken) {
            System.out.println("ArtikCloudMqttCallback::onSuccess() with Mode " + opMode);
        }

        public void connectionLost(Throwable cause) {
            System.out.println("Connection is lost due to " + cause);
            Assert.fail();
        }

        public void messageArrived(String topic, MqttMessage message) {
            System.out.println("Received message. Payload: " + new String(message.getPayload()) + ". Qos:" + message.getQos() + "; Topic:" + topic);
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
        }
    };

    @Before
    public void setUp() {
        System.out.println("\nsetUp");
        this.deviceId = Config.smartLightDeviceId;
        Assert.assertNotNull((Object)this.deviceId);
        Assert.assertFalse((boolean)this.deviceId.isEmpty());
        this.deviceToken = Config.smartLightdeviceToken;
        Assert.assertNotNull((Object)this.deviceToken);
        Assert.assertFalse((boolean)this.deviceToken.isEmpty());
        System.out.println("Device ID:" + this.deviceId + "; Device Token:" + this.deviceToken);
        try {
            this.mqttSession = new MqttSession(this.deviceId, this.deviceToken, this.callback);
            System.out.println("Connecting to broker: " + this.mqttSession.getBrokerUri());
            this.mqttSession.connect();
            Thread.sleep(2000L);
            Assert.assertEquals((Object)true, (Object)this.mqttSession.isConnected());
        }
        catch (ArtikCloudMqttException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @After
    public void cleanup() {
        System.out.println("cleanup");
        try {
            this.mqttSession.disconnect();
            Thread.sleep(2000L);
            Assert.assertEquals((Object)false, (Object)this.mqttSession.isConnected());
        }
        catch (ArtikCloudMqttException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("====================");
    }

    @Test
    public void connectionTest() {
        System.out.println("Running connectionTest");
    }

    @Test
    public void publishTest() {
        System.out.println("Running publishTest");
        try {
            String payload = "{\"state\":true}";
            System.out.println("Publishing to topic: " + this.mqttSession.getPublishTopic() + "; message payload: " + payload);
            this.mqttSession.publish(2, payload);
            Thread.sleep(2000L);
        }
        catch (ArtikCloudMqttException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void subscribeTest() {
        System.out.println("Running subscribeTest");
        try {
            System.out.println("Subscribing to topic: " + this.mqttSession.getSubscribeTopic());
            this.mqttSession.subscribe();
            Thread.sleep(5000L);
        }
        catch (ArtikCloudMqttException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

