/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.websocket;

import cloud.artik.model.Acknowledgement;
import cloud.artik.model.ActionOut;
import cloud.artik.model.MessageIn;
import cloud.artik.model.MessageOut;
import cloud.artik.model.RegisterMessage;
import cloud.artik.model.WebSocketError;
import cloud.artik.websocket.ArtikCloudWebSocketCallback;
import cloud.artik.websocket.DeviceChannelWebSocket;
import com.squareup.okhttp.OkHttpClient;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeviceChannelWebSocketTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSendMessage() throws Exception {
        OkHttpClient client = new OkHttpClient();
        client.setRetryOnConnectionFailure(true);
        final CountDownLatch registerLatch = new CountDownLatch(1);
        final CountDownLatch messageLatch = new CountDownLatch(1);
        DeviceChannelWebSocket ws = new DeviceChannelWebSocket(true, client, new ArtikCloudWebSocketCallback(){

            public void onAck(Acknowledgement ack) {
                System.out.println("onAck: " + ack);
                if (ack.getCid().equalsIgnoreCase("first")) {
                    registerLatch.countDown();
                } else if (ack.getCid().equalsIgnoreCase("second")) {
                    messageLatch.countDown();
                }
            }

            public void onAction(ActionOut action) {
                System.out.println("onAction: " + action);
            }

            public void onClose(int code, String reason, boolean remote) {
                System.out.printf("onClose: %d %s %s\n", code, reason, remote);
            }

            public void onError(WebSocketError error) {
                System.err.println("onError: " + error);
            }

            public void onMessage(MessageOut message) {
                System.out.println("onMessage: " + message);
            }

            public void onOpen(int httpStatus, String httpStatusMessage) {
                System.out.printf("onOpen: %d %s\n", httpStatus, httpStatusMessage);
            }

            public void onPing(long timestamp) {
                System.out.println("onPing: " + timestamp);
            }
        });
        ws.connectBlocking();
        RegisterMessage msg = new RegisterMessage();
        msg.setAuthorization("bearer 1eef3e3251e147d1ac707a57f6779c49");
        msg.setSdid("993925c3cd994bf7a51c620884be65e9");
        msg.setCid("first");
        ws.registerChannel(msg);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)new Boolean(registerLatch.await(1L, TimeUnit.SECONDS)));
        MessageIn message = new MessageIn();
        message.setSdid("993925c3cd994bf7a51c620884be65e9");
        message.setTs(new Long(System.currentTimeMillis()));
        message.getData().put("volume", new Integer(5));
        message.setCid("second");
        ws.sendMessage(message);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)new Boolean(messageLatch.await(1L, TimeUnit.SECONDS)));
        ws.closeBlocking();
    }
}

