/*
 * Decompiled with CFR 0.152.
 */
package f2.spring.exception.config;

import com.fasterxml.jackson.module.kotlin.MissingKotlinParameterException;
import f2.dsl.cqrs.error.F2Error;
import f2.dsl.cqrs.error.F2ErrorDTO;
import f2.dsl.cqrs.exception.F2Exception;
import f2.spring.exception.config.F2ErrorAttributes;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
@Order(value=-2)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014\u00a8\u0006\u001d"}, d2={"Lf2/spring/exception/config/F2ErrorWebExceptionHandler;", "Lorg/springframework/boot/autoconfigure/web/reactive/error/DefaultErrorWebExceptionHandler;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "webProperties", "Lorg/springframework/boot/autoconfigure/web/WebProperties;", "serverCodecConfigurer", "Lorg/springframework/http/codec/ServerCodecConfigurer;", "viewResolvers", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/web/reactive/result/view/ViewResolver;", "serverProperties", "Lorg/springframework/boot/autoconfigure/web/ServerProperties;", "(Lorg/springframework/context/ApplicationContext;Lorg/springframework/boot/autoconfigure/web/WebProperties;Lorg/springframework/http/codec/ServerCodecConfigurer;Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/boot/autoconfigure/web/ServerProperties;)V", "getRoutingFunction", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "errorAttributes", "Lorg/springframework/boot/web/reactive/error/ErrorAttributes;", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "Lorg/springframework/web/server/ServerWebExchange;", "throwable", "", "renderErrorResponse", "request", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "f2-spring-boot-exception-http"})
public class F2ErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    public F2ErrorWebExceptionHandler(@NotNull ApplicationContext applicationContext, @NotNull WebProperties webProperties, @NotNull ServerCodecConfigurer serverCodecConfigurer, @NotNull ObjectProvider<ViewResolver> viewResolvers, @NotNull ServerProperties serverProperties) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)webProperties, (String)"webProperties");
        Intrinsics.checkNotNullParameter((Object)serverCodecConfigurer, (String)"serverCodecConfigurer");
        Intrinsics.checkNotNullParameter(viewResolvers, (String)"viewResolvers");
        Intrinsics.checkNotNullParameter((Object)serverProperties, (String)"serverProperties");
        super((ErrorAttributes)new F2ErrorAttributes(), webProperties.getResources(), serverProperties.getError(), applicationContext);
        this.setViewResolvers(CollectionsKt.toList((Iterable)((Iterable)viewResolvers)));
        this.setMessageWriters(serverCodecConfigurer.getWriters());
        this.setMessageReaders(serverCodecConfigurer.getReaders());
    }

    @NotNull
    protected RouterFunction<ServerResponse> getRoutingFunction(@Nullable ErrorAttributes errorAttributes) {
        RouterFunction routerFunction = super.getRoutingFunction(errorAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)routerFunction, (String)"super.getRoutingFunction(errorAttributes)");
        return routerFunction;
    }

    @NotNull
    public Mono<Void> handle(@NotNull ServerWebExchange exchange, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Throwable cause = throwable.getCause();
        if (cause instanceof F2Exception) {
            Mono mono = super.handle(exchange, cause);
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"super.handle(exchange, cause)");
            return mono;
        }
        if (cause instanceof MissingKotlinParameterException) {
            String string = UUID.randomUUID().toString();
            String string2 = String.valueOf(System.currentTimeMillis());
            String string3 = ((MissingKotlinParameterException)cause).getParameter().getName();
            Intrinsics.checkNotNull((Object)string3);
            String string4 = "Missing parameter `" + string3 + "`";
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
            Mono mono = super.handle(exchange, (Throwable)new F2Exception((F2ErrorDTO)new F2Error(string, string2, 400, string4, null, 16, null), null, 2, null));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"super.handle(exchange,  \u2026de = 400,\n            )))");
            return mono;
        }
        Mono mono = super.handle(exchange, throwable);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"super.handle(exchange, throwable)");
        return mono;
    }

    @Nullable
    protected Mono<ServerResponse> renderErrorResponse(@Nullable ServerRequest request) {
        Map error = this.getErrorAttributes(request, this.getErrorAttributeOptions(request, MediaType.ALL));
        Integer n = (Integer)error.get("code");
        int status = n != null ? n : 500;
        return ServerResponse.status((int)status).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)error));
    }
}

