/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.model;

import ch.zizka.junitdiff.model.Groups;
import ch.zizka.junitdiff.model.IGroup;
import ch.zizka.junitdiff.model.TestCaseInfo;
import ch.zizka.junitdiff.model.TestClassInfo;
import ch.zizka.junitdiff.model.TestRunInfo;
import ch.zizka.junitdiff.model.TestRunResultsList;
import ch.zizka.junitdiff.model.TestSuite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005J\b\u0010\u001a\u001a\u00020\u0005H\u0002J\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0011J \u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00112\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u001dR\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006&"}, d2={"Lch/zizka/junitdiff/model/AggregatedTestResults;", "", "()V", "byTestClassName", "", "", "Lch/zizka/junitdiff/model/TestClassInfo;", "groups", "", "Lch/zizka/junitdiff/model/IGroup;", "getGroups", "()Ljava/util/List;", "groupsFactory", "Lch/zizka/junitdiff/model/Groups;", "nextGroupNum", "", "testCases", "", "Lch/zizka/junitdiff/model/TestCaseInfo;", "getTestCases", "add", "", "testClass", "containsByClassName", "className", "findTestsByClassName", "generateGroupName", "getGroupsUnmodifiable", "merge", "", "reportsLists", "Lch/zizka/junitdiff/model/TestRunResultsList;", "groupName", "mergeTestSuites", "testSuites", "Lch/zizka/junitdiff/model/TestSuite;", "shortenGroupsNames", "Companion", "JUnitDiff"})
public final class AggregatedTestResults {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, TestClassInfo> byTestClassName = new LinkedHashMap();
    @NotNull
    private final List<IGroup> groups = new ArrayList();
    @NotNull
    private final Groups groupsFactory = new Groups();
    private int nextGroupNum = 1;
    private static final Logger log = LoggerFactory.getLogger(AggregatedTestResults.class);

    @NotNull
    public final List<IGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<TestRunResultsList> mergeTestSuites(@NotNull List<TestSuite> testSuites, @NotNull String groupName) {
        Intrinsics.checkNotNullParameter(testSuites, "testSuites");
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        List reportsLists = new ArrayList(testSuites.size());
        for (TestSuite testSuite : testSuites) {
            reportsLists.add(testSuite.getTestRunResultsList());
        }
        this.merge(reportsLists, groupName);
        return reportsLists;
    }

    @JvmOverloads
    public final void merge(@NotNull List<TestRunResultsList> reportsLists, @NotNull String groupName) {
        Intrinsics.checkNotNullParameter(reportsLists, "reportsLists");
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        boolean trace = log.isTraceEnabled();
        IGroup group = this.groupsFactory.getGroup(groupName);
        this.groups.add(group);
        for (TestRunResultsList testResultsList : reportsLists) {
            if (trace) {
                log.trace("  Aggregating {}", (Object)testResultsList);
            }
            for (TestRunInfo curTest : testResultsList.getTestResults()) {
                TestClassInfo testclass = this.findTestsByClassName(curTest.getClassname());
                if (testclass == null) {
                    testclass = new TestClassInfo(curTest.getClassname());
                    this.add(testclass);
                }
                curTest.setGroup(group);
                testclass.add(curTest);
            }
        }
    }

    public static /* synthetic */ void merge$default(AggregatedTestResults aggregatedTestResults, List list, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = aggregatedTestResults.generateGroupName();
        }
        aggregatedTestResults.merge(list, string);
    }

    private final String generateGroupName() {
        int n = this.nextGroupNum;
        this.nextGroupNum = n + 1;
        return "Group" + n;
    }

    public final boolean add(@NotNull TestClassInfo testClass) {
        Intrinsics.checkNotNullParameter(testClass, "testClass");
        this.byTestClassName.put(testClass.getClassName(), testClass);
        return true;
    }

    public final boolean containsByClassName(@Nullable String className) {
        return this.byTestClassName.containsKey(className);
    }

    @NotNull
    public final List<TestCaseInfo> getTestCases() {
        List ret = new ArrayList();
        for (TestClassInfo testclass : this.byTestClassName.values()) {
            ret.addAll((Collection)testclass.getTestCasesWithPseudoRuns());
        }
        return ret;
    }

    @NotNull
    public final List<IGroup> getGroupsUnmodifiable() {
        List<IGroup> list = Collections.unmodifiableList(this.groups);
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(groups)");
        return list;
    }

    @Nullable
    public final TestClassInfo findTestsByClassName(@Nullable String className) {
        return this.byTestClassName.get(className);
    }

    public final void shortenGroupsNames() {
        this.groupsFactory.shortenNames();
    }

    @JvmOverloads
    public final void merge(@NotNull List<TestRunResultsList> reportsLists) {
        Intrinsics.checkNotNullParameter(reportsLists, "reportsLists");
        AggregatedTestResults.merge$default(this, reportsLists, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lch/zizka/junitdiff/model/AggregatedTestResults$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "JUnitDiff"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

