package ch.stegmaier.java2tex.commands.registry.environments;

import ch.stegmaier.java2tex.commands.BaseCommand;
import ch.stegmaier.java2tex.commands.GenericCommand;
import ch.stegmaier.java2tex.commands.Tabular;

/**
 * The package was a predecessor of longtable; the newer package (designed on quite different principles)
 * is easier to use and more flexible, in many cases, but supertabular retains its usefulness in a few situations
 * where longtable has problems.
 * @see <a href="https://www.ctan.org/pkg/supertabular">supertabular – A multi-page tables package</a>
 */
public class Supertabular {

    private Supertabular() {}

    /**
     * supertabular environment
     */
    public static Tabular supertabular() {
        return new Tabular("supertabular");
    }

    /**
     * A column stretched to max table width, only in tabularX environment
     */
    public static BaseCommand stretch() {
        return new BaseCommand("X");
    }

    /**
     * A column of left-aligned items.
     */
    public static GenericCommand left() {
        return new GenericCommand("L").noPrefix();
    }

    /**
     * A column of right-aligned items.
     */
    public static GenericCommand right() {
        return new GenericCommand("R").noPrefix();
    }

    public static GenericCommand fixedSize() {
        return new GenericCommand("P").noPrefix();
    }

    /**
     * @see <a href="https://tex.stackexchange.com/questions/105717/trick-supertabular-into-multicols-in-new-command">Trick Supertabular into Multicols in new command</a>
     */
    public static GenericCommand TrickSupertabularIntoMulticols() {
        return new GenericCommand("TrickSupertabularIntoMulticols").autoNewline();
    }

}
