package ch.stegmaier.java2tex.commands.registry.environments;

import ch.stegmaier.java2tex.commands.GenericCommand;
import ch.stegmaier.java2tex.commands.GenericEnvironment;
import ch.stegmaier.java2tex.commands.IncludeGraphics;

public class Figure {

    /**
     * Figures are for material that is not part of the normal text. An example is material that you cannot have split between two pages, such as a graphic.
     * @see <a href="https://latexref.xyz/figure.html">figure environment</a>
     */
    public static GenericCommand figure() {return new GenericEnvironment("figure");}

    public static GenericCommand subfigure() {return new GenericEnvironment("subfigure");}

    /**
     * Include a graphics file. The starred form \includegraphics* will clip the graphic to the size specified, while for the unstarred form any part of the graphic that is outside the box of the specified size will over-print the surrounding area.
     * @see <a href="https://latexref.xyz/_005cincludegraphics.html">includegraphics command</a>
     */
    public static IncludeGraphics includegraphics() {
        return new IncludeGraphics();
    }


}
