package ch.stegmaier.java2tex.commands.registry.ctan;

import ch.stegmaier.java2tex.commands.GenericCommand;
import ch.stegmaier.java2tex.commands.GenericEnvironment;

/**
 * multicol – Intermix single and multiple columns
 * @see <a href="https://www.ctan.org/pkg/multicol">ctan multicol</a>
 */
public class Multicol {

    private Multicol() {}

    /**
     * defines a multicols environment
     */
    public static GenericEnvironment multicols() {
        return new GenericEnvironment("multicols");
    }

    /**
     * defines a columnbreak in a multicols environment
     */
    public static GenericCommand columnbreak() {
        return new GenericCommand("columnbreak").autoNewline();
    }

}
