package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.GenericCommand;

/**
 * LaTeX lets you split a large document into several smaller ones. This can simplify editing or allow multiple authors to work on the document. It can also speed processing.
 * @see <a href="https://latexref.xyz/Splitting-the-input.html">Splitting the input</a>
 */
public class SplittingInput {

    private SplittingInput() {}

    /**
     * LaTeX processes the file as if its contents were inserted in the current file.
     * @see <a href="https://latexref.xyz/_005cinput.html">input command</a>
     */
    public static GenericCommand input() {
        return new GenericCommand("input").autoNewline().noFormat();
    }

    /**
     * Bring material from the external file filename.tex into a LaTeX document.
     * @see <a href="https://latexref.xyz/_005cinclude-_0026-_005cincludeonly.html">include command</a>
     */
    public static GenericCommand include() {
        return new GenericCommand("include").autoNewline().noFormat();
    }

}
