package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.BaseCommand;
import ch.stegmaier.java2tex.commands.GenericCommand;

/**
 * LaTeX has many ways to produce white space, or filled space. Some of these are best suited to mathematical text; for these see Spacing in math mode.
 * @see <a href="https://latexref.xyz/Spaces.html">Spaces</a>
 * @see <a href="https://latexref.xyz/Spacing-in-math-mode.html">Spacing in math mode</a>
 */
public class Spaces {

    private Spaces() {}

    /**
     * Produce a rubber length which has no natural space but that can stretch horizontally as far as needed.
     * @see <a href="https://latexref.xyz/_005chfill.html">hfill</a>
     */
    public static GenericCommand hfill() {
        return new GenericCommand("hfill").autoNewline();
    }

    /**
     * Non Breaking Space
     */
    public static BaseCommand nbs() {
        return new BaseCommand("\\,");
    }

    /**
     * Add the vertical space length. The length can be positive, negative, or zero. It is a rubber length—it may contain a plus or minus component
     * @see <a href="https://latexref.xyz/_005cvspace.html">vspace</a>
     */
    public static GenericCommand vspace() {
        return new GenericCommand("vspace").autoNewline();
    }

    /**
     * End the current paragraph and insert a vertical rubber length that is infinite, so it can stretch or shrink as far as needed.
     * @see <a href="https://latexref.xyz/_005cvfill.html">vfill</a>
     */
    public static GenericCommand vfill() {
        return new GenericCommand("vfill");
    }
}
