package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.GenericCommand;

/**
 * Structure your text into divisions: parts, chapters, sections, etc. All sectioning commands have the same form.
 * @see <a href="https://latexref.xyz/Sectioning.html">Sectioning</a>
 */
public class Sectioning {

    private Sectioning() {}

    /**
     * Start a section. The standard LaTeX classes article, book, and report all have this command.
     * @see <a href="https://latexref.xyz/_005csection.html">section command</a>
     */
    public static GenericCommand section() {return new GenericCommand("section").autoNewline();}

    /**
     * Start a subsection. The standard LaTeX classes article, book, and report all have this command.
     * @see <a href="https://latexref.xyz/_005csubsection.html">subsection command</a>
     */
    public static GenericCommand subsection() {return new GenericCommand("subsection").autoNewline();}

    /**
     * Start a subsubsection. The standard LaTeX classes article, book, and report all have these commands, although they are not commonly used.
     * @see <a href="https://latexref.xyz/_005csubsubsection-_0026-_005cparagraph-_0026-_005csubparagraph.html">subsubsection command</a>
     */
    public static GenericCommand subsubsection() {return new GenericCommand("subsubsection").autoNewline();}
}
