package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.GenericCommand;

public class Paragraphs {

    private Paragraphs() {}

    /**
     * not a standard LaTeX command, just a container for text or other commands
     */
    public static GenericCommand p() {
        return new GenericCommand(null);
    }

    /**
     * To start a paragraph without an indent, or to continue an interrupted paragraph, use \noindent.
     * @see <a href="https://latexref.xyz/_005cindent-_0026-_005cnoindent.html">noindent</a>
     */
    public static GenericCommand noindent() {
        return new GenericCommand("noindent").autoNewline();
    }

}
