package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.GenericCommand;

/**
 * Ordinarily LaTeX automatically takes care of breaking output into pages with its usual aplomb. But if you are writing commands, or tweaking the final version of a document, then you may need to understand how to influence its actions.
 * @see <a href="https://latexref.xyz/Page-breaking.html">Page breaking</a>
 */
public class Pagebreaking {

    private Pagebreaking() {}

    /**
     * End the current page.
     * @see <a href="https://latexref.xyz/_005cnewpage.html">newpage</a>
     */
    public static GenericCommand newpage() {
        return new GenericCommand("newpage").autoNewline();
    }

    /**
     * End the current page and output all of the pending floating figures and tables.
     * @see <a href="https://latexref.xyz/_005cclearpage-_0026-_005ccleardoublepage.html">clearpage command</a>
     */
    public static GenericCommand clearpage() {
        return new GenericCommand("clearpage").autoNewline();
    }

}
