package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.GenericCommand;

/**
 * The first thing LaTeX does when processing ordinary text is to translate your input file into a sequence of glyphs and spaces.
 * To produce a printed document, this sequence must be broken into lines (and these lines must be broken into pages).
 * @see <a href="https://latexref.xyz/Line-breaking.html">Line breaking</a>
 */
public class Linebreaking {

    private Linebreaking() {}

    /**
     * In ordinary text, this ends a line in a way that does not right-justify it, so the text before the end of line is not stretched.
     * @see <a href="https://latexref.xyz/_005cnewline.html">newline command</a>
     */
    public static GenericCommand newline() {
        return new GenericCommand("newline").autoNewline();
    }


}
