package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.BaseCommand;
import ch.stegmaier.java2tex.commands.GenericCommand;
import ch.stegmaier.java2tex.commands.GenericEnvironment;

/**
 * Startup and ending of all all documents
 * @see <a href="https://latexref.xyz/Starting-and-ending.html">Startup and ending</a>
 */
public class Document {

    private Document() {}

    /**
     * Load a package pkg, with the package options given in the comma-separated list options, as here.
     * @see <a href="https://latexref.xyz/Additional-packages.html">usepackage</a>
     */
    public static GenericCommand usepackage() {
        return new GenericCommand("usepackage").autoNewline();
    }

    /**
     * LaTeX files have a simple global structure, with a standard beginning and ending. This is a small example.
     * @see <a href="https://latexref.xyz/Starting-and-ending.html">document</a>
     */
    public static GenericEnvironment document() {
        return new GenericEnvironment("document");
    }

    /**
     * The document’s overall class is defined with this command, which is normally the first command in a LaTeX source file.
     * @see <a href="https://latexref.xyz/Document-classes.html">documentclass</a>
     */
    public static GenericCommand documentclass() {
        return new GenericCommand("documentclass").autoNewline();
    }

    /**
     * documentclass argument: for a journal article, a presentation, and miscellaneous general use
     */
    public static BaseCommand article() {
        return new BaseCommand("article");
    }

    /**
     * documentclass argument: for documents of length between an article and a book, such as technical reports or theses, which may contain several chapters.
     */
    public static BaseCommand report() {
        return new BaseCommand("report");
    }

    /**
     * documentclass argument: full-length books, including chapters and possibly including front matter, such as a preface, and back matter, such as an appendix
     */
    public static BaseCommand book() {
        return new BaseCommand("book");
    }

}
