package ch.stegmaier.java2tex.commands.registry;

import ch.stegmaier.java2tex.commands.GenericCommand;

/**
 * We often want something like ‘See Theorem~31’. But by-hand typing the 31 is poor practice. Instead you should write a label such as \label{eq:GreensThm} and then reference it, as with See equation~\ref{eq:GreensThm}.
 * LaTeX will automatically work out the number, put it into the output, and will change that number later if needed.
 * @see <a href="https://latexref.xyz/Cross-references.html">Cross References</a>
 */
public class CrossReferences {

    private CrossReferences() {}

    /**
     * Assign a reference number to key.
     * @see <a href="https://latexref.xyz/_005clabel.html">label command</a>
     */
    public static GenericCommand label() {
        return new GenericCommand("label").autoNewline();
    }

    /**
     * Produce the page number of the place in the text where the corresponding \\label{key} command appears.
     * @see <a href="https://latexref.xyz/_005cpageref.html">pageref command</a>
     */
    public static GenericCommand pageref() {
        return new GenericCommand("pageref");
    }
}
