package ch.stegmaier.java2tex.commands;

public class Tabular extends GenericEnvironment<Tabular> {

    private Row row = new Row();

    public Tabular() {
        this("tabular");
    }

    public Tabular(String commandName) {
        super(commandName);
    }

    public Tabular addRow(Row row) {
        this.row = row;
        endRow();
        return getThis();
    }

    public Tabular addCols(final String... cols) {
        row.addCols(cols);
        endRow();
        return getThis();
    }

    public Tabular addCol(final GenericCommand command) {
        row.addCol(command);
        return getThis();
    }

    public Tabular addCol(final String col) {
        row.addCol(col);
        return getThis();
    }

    public Tabular endRow() {
        append(row.toString());
        row = new Row();
        return getThis();
    }
}
