package ch.stegmaier.java2tex.commands;

import static ch.stegmaier.java2tex.commands.registry.environments.Table.colSep;
import static ch.stegmaier.java2tex.commands.registry.environments.Table.lf;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

public class Row<X extends Row> extends BaseCommand<X> {

    private List<String> columns = new LinkedList<>();

    public Row() {
        super("");
    }

    public X addCol(Optional<String> optional) {
        addCol(optional.orElse(" "));
        return getThis();
    }

    public X addCol(String text) {
        if (StringUtils.isNotEmpty(text)) {
            columns.add(formatValue(text));
        } else {
            columns.add("");
        }
        return getThis();
    }

    public X addCols(final String... cols) {
        Arrays.asList(cols).forEach(col -> addCol(col));
        return getThis();
    }

    public X addCol(final GenericCommand command) {
        columns.add(StringUtils.replace(command.toString(), "\n", " "));
        return getThis();
    }

    public String toString() {
        var row = new StringBuilder();
        row.append(columns.stream().collect(Collectors.joining(colSep().toString()))).append(lf());
        return row.toString();
    }

}
