package ch.stegmaier.java2tex.commands;

import org.apache.commons.lang3.StringUtils;

public class IncludeGraphics extends GenericCommand<IncludeGraphics> {

    private String width;
    private String height;
    private boolean keepaspectratio;

    public IncludeGraphics() {
        super("includegraphics");
        noFormat().autoNewline();
    }

    public IncludeGraphics height(String height) {
        this.height = height;
        return getThis();
    }

    public IncludeGraphics width(String width) {
        this.width = width;
        return getThis();
    }

    public IncludeGraphics width(BaseCommand width) {
        this.width = width.toString();
        return getThis();
    }

    public IncludeGraphics keepaspectratio() {
        this.keepaspectratio = true;
        return getThis();
    }

    public IncludeGraphics fileName(String fileName) {
        super.argument("_images/" + fileName);
        return getThis();
    }

    @Override
    protected String buildOptional() {
        var options = new StringBuilder();
        if (StringUtils.isNotEmpty(width)) {
            options.append("width=").append(width);
        }
        if (StringUtils.isNotEmpty(height)) {
            if (options.length()!=0) {
                options.append(",");
            }
            options.append("height=").append(height);
        }
        if (keepaspectratio) {
            if (options.length()!=0) {
                options.append(",");
            }
            options.append("keepaspectratio");
        }
        return options.length()==0 ? super.buildOptional() : ("[" + options + "]" + super.buildOptional());
    }

}
