package ch.stegmaier.java2tex.commands;

import org.apache.commons.lang3.StringUtils;

public class GenericEnvironment<X extends GenericCommand> extends GenericCommand<X> {

    private static final String BEGIN = "\\begin";
    private static final String END = "\\end";

    public GenericEnvironment(final String commandName) {
        super(commandName);
    }

    @Override
    public String toString() {
        return buildContextBegin() + buildContextEnd();
    }

    public X append(String text) {
        return append(text, true);
    }

    @Override
    protected String buildName() {
        return StringUtils.isEmpty(this.getCommand()) ? "" : this.getCommand();
    }

    private String buildContextBegin() {
        var sb = new StringBuilder()
                .append(BEGIN).append("{")
                .append(buildName()).append("}")
                .append(buildOptional())
                .append(buildMandatory())
                .append("\n");
        String content = getContent();
        if (!content.isEmpty()) {
            sb.append(content);
            if (!content.endsWith("\n")) {
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String buildContextEnd() {
        var sb = new StringBuilder()
                .append(END).append("{")
                .append(buildName()).append("}")
                .append("\n");
        return sb.toString();
    }

}
