package ch.stegmaier.java2tex.commands;

import org.apache.commons.lang3.StringUtils;

public class BaseCommand<X> {

    private final String command;

    public BaseCommand(String command) {
        this.command = command;
    }

    protected String getCommand() {
        return this.command;
    }

    protected X getThis() {
        return (X) this;
    }

    // & % $ # _ { } ~ ^ \
    protected static String formatValue(String val) {
        var result = StringUtils.replace(val, "&", "\\&");
        result = StringUtils.replace(result, "#", " ");
        result = StringUtils.replace(result, "%", "\\%");
        result = StringUtils.replace(result, "_", " ");
        result = StringUtils.replace(result, "%TAB%", "&");
        return result;
    }

    @Override
    public String toString() {
        return command;
    }
}
