/*
 * Decompiled with CFR 0.152.
 */
package idx.ws.client.util;

import idx.ws.client.util.exception.GenericServerExceptinon;
import idx.ws.client.util.exception.UnauthorizedException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.xml.ws.http.HTTPException;

public final class ResponseExceptionMapper {
    private ResponseExceptionMapper() {
    }

    public static Response check(Response response, int ... expectedStatus) throws HTTPException {
        ResponseExceptionMapper.check(response);
        for (int status : expectedStatus) {
            if (response.getStatus() != status) continue;
            return response;
        }
        throw new IllegalStateException("Unexpected return status: " + response.getStatus());
    }

    public static Response check(Response response) throws HTTPException {
        if (response == null) {
            throw new NullPointerException("response must not be null");
        }
        int status = response.getStatus();
        if (status >= 400) {
            if (status == 400) {
                throw new BadRequestException((String)response.readEntity(String.class));
            }
            if (status == 401) {
                throw new UnauthorizedException((String)response.readEntity(String.class));
            }
            if (status == 403) {
                throw new ForbiddenException((String)response.readEntity(String.class));
            }
            if (status == 404) {
                throw new NotFoundException((String)response.readEntity(String.class));
            }
            if (status == 405) {
                throw new NotAllowedException((String)response.readEntity(String.class), new String[0]);
            }
            if (status == 500) {
                throw new InternalServerErrorException((String)response.readEntity(String.class));
            }
            throw new GenericServerExceptinon(status, (String)response.readEntity(String.class));
        }
        return response;
    }
}

