/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.SourceLookUpProvider;
import ch.epfl.scala.debugadapter.internal.evaluator.Invalid;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiFrame;
import ch.epfl.scala.debugadapter.internal.evaluator.RuntimeEvaluation;
import ch.epfl.scala.debugadapter.internal.evaluator.RuntimeEvaluationTree;
import ch.epfl.scala.debugadapter.internal.evaluator.RuntimeExpression;
import ch.epfl.scala.debugadapter.internal.evaluator.RuntimeValidation;
import ch.epfl.scala.debugadapter.internal.evaluator.Valid;
import ch.epfl.scala.debugadapter.internal.evaluator.Validation;
import com.sun.jdi.Value;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001m3AAB\u0004\u0001)!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u0015!\u0003\u0001\"\u0001&\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015a\u0005\u0001\"\u0001N\u0005A\u0011VO\u001c;j[\u0016,e/\u00197vCR|'O\u0003\u0002\t\u0013\u0005IQM^1mk\u0006$xN\u001d\u0006\u0003\u0015-\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00195\tA\u0002Z3ck\u001e\fG-\u00199uKJT!AD\b\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005A\t\u0012\u0001B3qM2T\u0011AE\u0001\u0003G\"\u001c\u0001a\u0005\u0002\u0001+A\u0011a\u0003G\u0007\u0002/)\ta\"\u0003\u0002\u001a/\t1\u0011I\\=SK\u001a\fAb]8ve\u000e,Gj\\8l+B\u0004\"\u0001H\u000f\u000e\u0003%I!AH\u0005\u0003)M{WO]2f\u0019>|7.\u00169Qe>4\u0018\u000eZ3s\u0003\u0019awnZ4feB\u0011\u0011EI\u0007\u0002\u0017%\u00111e\u0003\u0002\u0007\u0019><w-\u001a:\u0002\rqJg.\u001b;?)\r1\u0003&\u000b\t\u0003O\u0001i\u0011a\u0002\u0005\u00065\r\u0001\ra\u0007\u0005\u0006?\r\u0001\r\u0001I\u0001\tm\u0006d\u0017\u000eZ1uKR!A&\u000e\"H!\ri\u0003GM\u0007\u0002])\u0011qfF\u0001\u0005kRLG.\u0003\u00022]\t\u0019AK]=\u0011\u0005\u001d\u001a\u0014B\u0001\u001b\b\u0005E\u0011VO\u001c;j[\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006m\u0011\u0001\raN\u0001\u000bKb\u0004(/Z:tS>t\u0007C\u0001\u001d@\u001d\tIT\b\u0005\u0002;/5\t1H\u0003\u0002='\u00051AH]8pizJ!AP\f\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}]AQa\u0011\u0003A\u0002\u0011\u000bQA\u001a:b[\u0016\u0004\"aJ#\n\u0005\u0019;!\u0001\u0003&eS\u001a\u0013\u0018-\\3\t\u000b!#\u0001\u0019A%\u0002\u001bA\u0014X-\u0012<bYV\fG/[8o!\t1\"*\u0003\u0002L/\t9!i\\8mK\u0006t\u0017\u0001C3wC2,\u0018\r^3\u0015\u00079K&\fE\u0002.a=\u0003\"\u0001U,\u000e\u0003ES!AU*\u0002\u0007)$\u0017N\u0003\u0002U+\u0006\u00191/\u001e8\u000b\u0003Y\u000b1aY8n\u0013\tA\u0016KA\u0003WC2,X\rC\u00037\u000b\u0001\u0007!\u0007C\u0003D\u000b\u0001\u0007A\t")
public class RuntimeEvaluator {
    private final SourceLookUpProvider sourceLookUp;
    private final Logger logger;

    public Try<RuntimeExpression> validate(String expression, JdiFrame frame, boolean preEvaluation) {
        RuntimeValidation validation = new RuntimeValidation(frame, this.sourceLookUp, preEvaluation, this.logger);
        Validation<RuntimeEvaluationTree> validation2 = validation.validate(expression);
        if (validation2 instanceof Invalid) {
            Invalid invalid = (Invalid)((Object)validation2);
            return new Failure(invalid.exception());
        }
        if (validation2 instanceof Valid) {
            Valid valid = (Valid)validation2;
            RuntimeEvaluationTree expr = (RuntimeEvaluationTree)valid.value();
            return new Success((Object)new RuntimeExpression(expr));
        }
        throw new MatchError(validation2);
    }

    public Try<Value> evaluate(RuntimeExpression expression, JdiFrame frame) {
        RuntimeEvaluation evaluation = new RuntimeEvaluation(frame, this.logger);
        return evaluation.evaluate(expression.tree()).getResult().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.value());
    }

    public RuntimeEvaluator(SourceLookUpProvider sourceLookUp, Logger logger) {
        this.sourceLookUp = sourceLookUp;
        this.logger = logger;
    }
}

