/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.SourceDirectory;
import ch.epfl.scala.debugadapter.SourceEntry;
import ch.epfl.scala.debugadapter.SourceJar;
import ch.epfl.scala.debugadapter.StandaloneSourceFile;
import ch.epfl.scala.debugadapter.internal.IO$;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceEntryLookUp;
import ch.epfl.scala.debugadapter.internal.SourceFile;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class SourceEntryLookUp$
implements scala.Serializable {
    public static SourceEntryLookUp$ MODULE$;

    static {
        new SourceEntryLookUp$();
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    public Option<SourceEntryLookUp> apply(SourceEntry entry, Logger logger) {
        SourceEntry sourceEntry = entry;
        if (sourceEntry instanceof SourceJar) {
            SourceJar sourceJar = (SourceJar)sourceEntry;
            Path jar = sourceJar.jar();
            return ScalaExtension$.MODULE$.TryExtension(IO$.MODULE$.getJarFileSystem(jar).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    FileSystem fs = (FileSystem)tuple2._1();
                    boolean shouldClose = tuple2._2$mcZ$sp();
                    Path root = fs.getPath("/", new String[0]);
                    Vector sourceFiles = MODULE$.getAllSourceFiles(entry, fs, root).toVector();
                    return new SourceEntryLookUp(entry, (Seq<SourceFile>)sourceFiles, fs, root, shouldClose);
                }
                throw new MatchError((Object)tuple2);
            })).warnFailure(logger, new StringBuilder(32).append("Cannot list the source files in ").append(entry.name()).toString());
        }
        if (sourceEntry instanceof SourceDirectory) {
            SourceDirectory sourceDirectory = (SourceDirectory)sourceEntry;
            Path directory = sourceDirectory.directory();
            FileSystem fs = FileSystems.getDefault();
            Vector sourceFiles = this.getAllSourceFiles(entry, fs, directory).toVector();
            return new Some((Object)new SourceEntryLookUp(entry, (Seq<SourceFile>)sourceFiles, fs, directory, this.apply$default$5()));
        }
        if (sourceEntry instanceof StandaloneSourceFile) {
            StandaloneSourceFile standaloneSourceFile = (StandaloneSourceFile)sourceEntry;
            Path absolutePath = standaloneSourceFile.absolutePath();
            String relativePath = standaloneSourceFile.relativePath();
            FileSystem fs = FileSystems.getDefault();
            SourceFile sourceFile = new SourceFile(entry, relativePath, absolutePath.toUri());
            Path root = fs.getPath(sourceFile.folderPath(), new String[0]);
            return new Some((Object)new SourceEntryLookUp(entry, (Seq<SourceFile>)((Seq)new .colon.colon((Object)sourceFile, (List)Nil$.MODULE$)), FileSystems.getDefault(), root, this.apply$default$5()));
        }
        throw new MatchError((Object)sourceEntry);
    }

    public boolean apply$default$5() {
        return false;
    }

    private Iterator<SourceFile> getAllSourceFiles(SourceEntry entry, FileSystem fileSystem, Path root) {
        if (Files.exists(root, new LinkOption[0])) {
            PathMatcher sourceMatcher = fileSystem.getPathMatcher("glob:**.{scala,java}");
            return ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(Files.walk(root, new FileVisitOption[0]).filter(x$1 -> sourceMatcher.matches((Path)x$1)).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)path -> {
                String relativePath = ((Object)root.relativize((Path)path)).toString().replace('\\', '/');
                return new SourceFile(entry, relativePath, path.toUri());
            });
        }
        return package$.MODULE$.Iterator().empty();
    }

    public SourceEntryLookUp apply(SourceEntry entry, Seq<SourceFile> sourceFiles, FileSystem fileSystem, Path root, boolean shouldCloseFileSystem) {
        return new SourceEntryLookUp(entry, sourceFiles, fileSystem, root, shouldCloseFileSystem);
    }

    public Option<Tuple5<SourceEntry, Seq<SourceFile>, FileSystem, Path, Object>> unapply(SourceEntryLookUp x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.entry(), x$0.sourceFiles(), (Object)x$0.fileSystem(), (Object)x$0.root(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.shouldCloseFileSystem())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SourceEntryLookUp$() {
        MODULE$ = this;
    }
}

