package bloop.integration.sbt

import sbt.ProjectRef
import sbt.ResolvedProject

object Feedback {
  def unknownConfigurations(p: ResolvedProject, confs: Seq[String], from: ProjectRef): String = {
    s"""Unsupported dependency '${p.id}' -> '${from.project}:${confs.mkString(
      ", "
    )}' is conservatively interpreted as '${from.project}:test'.""".stripMargin
  }

  def warnReferenceToClassesDir(scalacOption: String, oldClassesDir: String): String = {
    s"Replacing '$oldClassesDir' reference in '$scalacOption' by Bloop's new classes directory."
  }
}
