/*
 * Decompiled with CFR 0.152.
 */
package bloop.engine.tasks.compilation;

import bloop.Compiler;
import bloop.UniqueCompileInputs;
import bloop.cli.CommonOptions;
import bloop.engine.ExecutionContext$;
import bloop.engine.SourceGenerator;
import bloop.engine.caches.LastSuccessfulResult;
import bloop.engine.caches.SourceGeneratorCache;
import bloop.engine.tasks.compilation.CancelledCompileBundle$;
import bloop.engine.tasks.compilation.CompileBundle;
import bloop.engine.tasks.compilation.CompileDefinitions;
import bloop.engine.tasks.compilation.CompileDependenciesData;
import bloop.engine.tasks.compilation.CompileDependenciesData$;
import bloop.engine.tasks.compilation.SuccessfulCompileBundle;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.io.ClasspathHasher$;
import bloop.io.SourceHasher$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import bloop.logging.LoggerAction;
import bloop.logging.ObservedLogger;
import bloop.reporter.ObservedReporter;
import bloop.reporter.ReporterAction;
import bloop.task.Task;
import bloop.task.Task$;
import bloop.tracing.BraveTracer;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Path;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import sbt.internal.inc.PlainVirtualFileConverter$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Promise;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CompileBundle$ {
    public static CompileBundle$ MODULE$;
    private final DebugFilter.Compilation$ filter;

    static {
        new CompileBundle$();
    }

    public DebugFilter.Compilation$ filter() {
        return this.filter;
    }

    public Task<CompileBundle> computeFrom(CompileDefinitions.BundleInputs inputs, SourceGeneratorCache sourceGeneratorCache, Path clientExternalClassesDir, ObservedReporter reporter, LastSuccessfulResult lastSuccessful, Compiler.Result lastResult, Promise<BoxedUnit> cancelCompilation, ObservedLogger<Logger> logger, Observable<Either<ReporterAction, LoggerAction>> mirror, BraveTracer tracer2, CommonOptions options) {
        return tracer2.traceTaskVerbose(new StringBuilder(17).append("computing bundle ").append(inputs.project().name()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)tracer -> {
            CompileDependenciesData compileDependenciesData = (CompileDependenciesData)tracer.traceVerbose("dependency classpath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$1 -> CompileDependenciesData$.MODULE$.compute((AbsolutePath[])inputs.project().rawClasspath().toArray(ClassTag$.MODULE$.apply(AbsolutePath.class)), inputs.dependentProducts()));
            PrintStream out = options.ngout();
            Task qual$1 = ClasspathHasher$.MODULE$.hash(compileDependenciesData.dependencyClasspath(), 10, cancelCompilation, ExecutionContext$.MODULE$.ioScheduler(), (Logger)logger, tracer, out);
            Scheduler x$12 = ExecutionContext$.MODULE$.ioScheduler();
            boolean x$22 = qual$1.executeOn$default$2();
            Task classpathHashesTask = qual$1.executeOn(x$12, x$22);
            Task sourceHashesTask = tracer.traceTaskVerbose("discovering and hashing sources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Function1 & Serializable & scala.Serializable)x$2 -> {
                Task qual$2 = SourceHasher$.MODULE$.findAndHashSourcesInProject(inputs.project(), (Function1<SourceGenerator, Task<List<AbsolutePath>>>)(Function1 & Serializable & scala.Serializable)x$3 -> sourceGeneratorCache.update((SourceGenerator)x$3, (Logger)logger, options), 20, cancelCompilation, ExecutionContext$.MODULE$.ioScheduler()).map((Function1 & Serializable & scala.Serializable)res -> res.map((Function1 & Serializable & scala.Serializable)x$4 -> (List)x$4.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.source().id(), (Ordering)Ordering.String$.MODULE$)));
                Scheduler x$32 = ExecutionContext$.MODULE$.ioScheduler();
                boolean x$4 = qual$2.executeOn$default$2();
                return qual$2.executeOn(x$32, x$4);
            });
            logger.debug(new StringBuilder(43).append("Computing sources and classpath hashes for ").append(inputs.project().name()).toString(), (DebugFilter)MODULE$.filter());
            return Task$.MODULE$.mapBoth(classpathHashesTask, sourceHashesTask, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Either either;
                Either either2;
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                    return CancelledCompileBundle$.MODULE$;
                }
                if (tuple2 != null && (either = (Either)tuple2._2()) instanceof Left) {
                    return CancelledCompileBundle$.MODULE$;
                }
                if (tuple2 != null) {
                    Either either3 = (Either)tuple2._1();
                    Either either4 = (Either)tuple2._2();
                    if (either3 instanceof Right) {
                        Right right = (Right)either3;
                        Vector classpathHashes = (Vector)right.value();
                        if (either4 instanceof Right) {
                            Right right2 = (Right)either4;
                            List sourceHashes = (List)right2.value();
                            String originPath = AbsolutePath$.MODULE$.syntax$extension(inputs.project().origin().path());
                            ListBuffer javaSources = new ListBuffer();
                            ListBuffer scalaSources = new ListBuffer();
                            sourceHashes.foreach((Function1 & Serializable & scala.Serializable)hashed -> {
                                Path source = AbsolutePath$.MODULE$.apply(PlainVirtualFileConverter$.MODULE$.converter().toPath(hashed.source()), AbsolutePath$.MODULE$.workingDirectory());
                                String sourceName = ((Object)source.getFileName()).toString();
                                if (sourceName.endsWith(".scala")) {
                                    return scalaSources.$plus$eq((Object)new AbsolutePath(source));
                                }
                                if (sourceName.endsWith(".java")) {
                                    return javaSources.$plus$eq((Object)new AbsolutePath(source));
                                }
                                return BoxedUnit.UNIT;
                            });
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaSources.toList()), (Object)scalaSources.toList());
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            List javaSources2 = (List)tuple22._1();
                            List scalaSources2 = (List)tuple22._2();
                            Tuple2 tuple23 = new Tuple2((Object)javaSources2, (Object)scalaSources2);
                            List javaSources3 = (List)tuple23._1();
                            List scalaSources3 = (List)tuple23._2();
                            Vector scalacOptions = inputs.project().scalacOptions().toVector();
                            Vector scalaJars = (Vector)Option$.MODULE$.option2Iterable(inputs.project().scalaInstance()).toVector().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7.allJars())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Vector$.MODULE$.canBuildFrom());
                            UniqueCompileInputs inputs = new UniqueCompileInputs(sourceHashes.toVector(), classpathHashes, scalacOptions, scalaJars, originPath);
                            return new SuccessfulCompileBundle(inputs.project(), clientExternalClassesDir, compileDependenciesData, (List<AbsolutePath>)javaSources3, (List<AbsolutePath>)scalaSources3, inputs, cancelCompilation, reporter, logger, mirror, lastSuccessful, lastResult, (BraveTracer)tracer);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        });
    }

    private CompileBundle$() {
        MODULE$ = this;
        this.filter = DebugFilter.Compilation$.MODULE$;
    }
}

