/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.bloop.internal;

import bloop.CompileMode;
import bloop.UniqueCompileInputs;
import bloop.reporter.ZincReporter;
import bloop.tracing.BraveTracer;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.ExternalLookup;
import sbt.internal.inc.InitialChanges;
import sbt.internal.inc.InvalidationProfiler;
import sbt.internal.inc.InvalidationProfiler$;
import sbt.internal.inc.Lookup;
import sbt.internal.inc.Relations;
import sbt.internal.inc.bloop.internal.BloopAnalysisCallback;
import sbt.internal.inc.bloop.internal.BloopNameHashing;
import sbt.internal.inc.bloop.internal.BloopStamps$;
import sbt.internal.inc.bloop.internal.ConcurrentAnalysisCallback;
import sbt.internal.inc.bloop.internal.IBloopAnalysisCallback;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Equiv;
import scala.math.Equiv$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import xsbti.AnalysisCallback;
import xsbti.api.AnalyzedClass;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.DependencyChanges;
import xsbti.compile.IncOptions;
import xsbti.compile.Output;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.Stamp;

public final class BloopIncremental$ {
    public static BloopIncremental$ MODULE$;

    static {
        new BloopIncremental$();
    }

    public Task<Tuple2<Object, Analysis>> compile(Iterable<File> sources, UniqueCompileInputs uniqueInputs, Lookup lookup, Function4<Set<File>, DependencyChanges, AnalysisCallback, ClassFileManager, Task<BoxedUnit>> compile, CompileAnalysis previous0, Output output, Logger log, ZincReporter reporter, IncOptions options, CompileMode mode, ClassFileManager manager, BraveTracer tracer, boolean isHydraEnabled) {
        Analysis analysis;
        ReadStamps current = BloopStamps$.MODULE$.initial();
        Function2 externalAPI = BloopIncremental$.getExternalAPI$1(lookup);
        CompileAnalysis compileAnalysis = previous0;
        if (!(compileAnalysis instanceof Analysis)) {
            throw new MatchError((Object)compileAnalysis);
        }
        Analysis analysis2 = analysis = (Analysis)compileAnalysis;
        Analysis previous = analysis2;
        Relations previousRelations = previous.relations();
        Function1 & Serializable & scala.Serializable internalBinaryToSourceClassName = (Function1 & Serializable & scala.Serializable)binaryClassName -> previousRelations.productClassName().reverse(binaryClassName).headOption();
        Function1 & Serializable & scala.Serializable internalSourceToClassNamesMap = (Function1 & Serializable & scala.Serializable)f -> previousRelations.classNames(f);
        Function0 & Serializable & scala.Serializable builder = !isHydraEnabled ? (Function0 & Serializable & scala.Serializable)() -> new BloopAnalysisCallback(mode, (Function1<String, Option<String>>)internalBinaryToSourceClassName, (Function1<File, Set<String>>)internalSourceToClassNamesMap, (Function2<File, String, Option<AnalyzedClass>>)externalAPI, current, output, options, manager) : (Function0 & Serializable & scala.Serializable)() -> new ConcurrentAnalysisCallback(mode, (Function1<String, Option<String>>)internalBinaryToSourceClassName, (Function1<File, Set<String>>)internalSourceToClassNamesMap, (Function2<File, String, Option<AnalyzedClass>>)externalAPI, current, output, options, manager);
        return this.compileIncremental(sources, uniqueInputs, lookup, previous, current, compile, (Function0<IBloopAnalysisCallback>)builder, reporter, log, output, options, manager, tracer, this.compileIncremental$default$14(), (Equiv<Stamp>)Equiv$.MODULE$.universalEquiv());
    }

    public Task<Tuple2<Object, Analysis>> compileIncremental(Iterable<File> sources, UniqueCompileInputs uniqueInputs, Lookup lookup, Analysis previous, ReadStamps current, Function4<Set<File>, DependencyChanges, AnalysisCallback, ClassFileManager, Task<BoxedUnit>> compile, Function0<IBloopAnalysisCallback> callbackBuilder, ZincReporter reporter, Logger log, Output output, IncOptions options, ClassFileManager manager, BraveTracer tracer, InvalidationProfiler profiler, Equiv<Stamp> equivS) {
        Set setOfSources = sources.toSet();
        BloopNameHashing incremental = new BloopNameHashing(log, reporter, uniqueInputs, options, profiler.profileRun(), tracer);
        InitialChanges initialChanges = incremental.detectInitialChanges((Set<File>)setOfSources, previous, current, lookup, output, equivS);
        DependencyChanges binaryChanges = new DependencyChanges(initialChanges){
            private final File[] modifiedBinaries;
            private final String[] modifiedClasses;

            public File[] modifiedBinaries() {
                return this.modifiedBinaries;
            }

            public String[] modifiedClasses() {
                return this.modifiedClasses;
            }

            public boolean isEmpty() {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedBinaries())).isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedClasses())).isEmpty();
            }
            {
                this.modifiedBinaries = (File[])initialChanges$1.binaryDeps().toArray(ClassTag$.MODULE$.apply(File.class));
                this.modifiedClasses = (String[])initialChanges$1.external().allModified().toArray(ClassTag$.MODULE$.apply(String.class));
            }
        };
        Tuple2 tuple2 = incremental.invalidateInitial(previous.relations(), initialChanges);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set initialInvClasses = (Set)tuple2._1();
        Set initialInvSources = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)initialInvClasses, (Object)initialInvSources);
        Tuple2 tuple23 = tuple22;
        Set initialInvClasses2 = (Set)tuple23._1();
        Set initialInvSources2 = (Set)tuple23._2();
        if (initialInvClasses2.nonEmpty() || initialInvSources2.nonEmpty()) {
            Set set = initialInvSources2;
            Iterable<File> iterable = sources;
            if (!(set != null ? !set.equals(iterable) : iterable != null)) {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> "All sources are invalidated.");
            } else {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("All initially invalidated classes: ").append(initialInvClasses2).append("\n").append("All initially invalidated sources:").append(initialInvSources2).append("\n").toString());
            }
        }
        Function2 & Serializable & scala.Serializable doCompile = (Function2 & Serializable & scala.Serializable)(srcs, changes) -> Task$.MODULE$.now(callbackBuilder.apply()).flatMap((Function1 & Serializable & scala.Serializable)callback -> ((Task)compile.apply(srcs, changes, callback, (Object)manager)).map((Function1 & Serializable & scala.Serializable)_ -> callback.get()));
        Task<Analysis> analysisTask = incremental.entrypoint((Set<String>)initialInvClasses2, (Set<File>)initialInvSources2, (Set<File>)setOfSources, binaryChanges, (ExternalLookup)lookup, previous, (Function2<Set<File>, DependencyChanges, Task<Analysis>>)doCompile, manager, 1);
        return analysisTask.materialize().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    manager.complete(false);
                    throw e;
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Analysis analysis = (Analysis)success.value();
            manager.complete(true);
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((initialInvClasses2.nonEmpty() || initialInvSources2.nonEmpty() ? 1 : 0) != 0), (Object)analysis);
            return tuple2;
        });
    }

    public InvalidationProfiler compileIncremental$default$14() {
        return InvalidationProfiler$.MODULE$.empty();
    }

    private static final Function2 getExternalAPI$1(Lookup lookup) {
        return (Function2 & Serializable & scala.Serializable)(x$1, binaryClassName) -> lookup.lookupAnalysis(binaryClassName).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CompileAnalysis compileAnalysis = x0$1;
            if (!(compileAnalysis instanceof Analysis)) {
                throw new MatchError((Object)compileAnalysis);
            }
            Analysis analysis = (Analysis)compileAnalysis;
            Option sourceClassName = analysis.relations().productClassName().reverse(binaryClassName).headOption();
            Map map = analysis.apis().internal();
            Option option = sourceClassName.flatMap((Function1 & Serializable & scala.Serializable)key -> map.get(key));
            return option;
        });
    }

    private BloopIncremental$() {
        MODULE$ = this;
    }
}

