package cc.xbyter.code.generator.engine;

import cc.xbyter.code.generator.config.ConstVal;
import cc.xbyter.code.generator.config.TemplateConfig;
import cc.xbyter.code.generator.config.po.TableInfo;
import cc.xbyter.code.generator.config.rules.ProjectType;
import cc.xbyter.code.generator.config.rules.StringUtils;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * @author cc
 */
public class ColaTemplateEngine extends AbstractTemplateEngine {
    @Override
    public AbstractTemplateEngine batchOutPut() throws Exception {
        List<TableInfo> tableInfoList = this.configBuilder.getTableInfoList();
        for (TableInfo tableInfo : tableInfoList) {
            Map<String, Object> objectMap = getObjectMap(tableInfo);
            TemplateConfig template = getConfigBuilder().getTemplateConfig();

            if (configBuilder.getGlobalConfig().getProjectType().equals(ProjectType.COLA)) {
                outPutPomCola(template, objectMap);
                outPutClassCola(template, objectMap, tableInfo);
            } else {
                throw new Exception("=========未实现=========");
            }

        }
        return this;
    }


    // region cola架构
    void outPutClassCola(TemplateConfig template, Map<String, Object> objectMap, TableInfo tableInfo) throws Exception {

        // region 生成Controller类
        writer(objectMap, templateFilePath(template.getColaController()),
                configBuilder.getPathInfo().get(ConstVal.COLA_CONTROLLER_PATH) +
                        StrUtil.format("/{}Controller.java", tableInfo.getEntityName()));
        // endregion

        // region 生成ServiceImpl类
        writer(objectMap, templateFilePath(template.getColaServiceImpl()),
                configBuilder.getPathInfo().get(ConstVal.COLA_SERVICE_IMPL_PATH) +
                        StrUtil.format("/{}ServiceImpl.java", tableInfo.getEntityName()));
        // endregion
        // region 生成Service类
        writer(objectMap, templateFilePath(template.getColaService()),
                configBuilder.getPathInfo().get(ConstVal.COLA_SERVICE_PATH) +
                        StrUtil.format("/{}Service.java", tableInfo.getEntityName()));
        // endregion
        // region 生成PageItemVO类
        writer(objectMap, templateFilePath(template.getColaPageItemVO()),
                configBuilder.getPathInfo().get(ConstVal.COLA_DTO_DETAIL_VO_PATH) +
                        StrUtil.format("/{}PageItemVO.java", tableInfo.getEntityName()));
        // endregion
        // region 生成DetailVO类
        writer(objectMap, templateFilePath(template.getColaDetailVO()),
                configBuilder.getPathInfo().get(ConstVal.COLA_DTO_DETAIL_VO_PATH) +
                        StrUtil.format("/{}DetailVO.java", tableInfo.getEntityName()));
        // endregion
        // region 生成EditCmd类
        writer(objectMap, templateFilePath(template.getColaEditCmd()),
                configBuilder.getPathInfo().get(ConstVal.COLA_DTO_CMD_PATH) +
                        StrUtil.format("/{}EditCmd.java", tableInfo.getEntityName()));
        // endregion
        // region 生成PageQuery类
        writer(objectMap, templateFilePath(template.getColaPageQuery()),
                configBuilder.getPathInfo().get(ConstVal.COLA_DTO_QUERY_PATH) +
                        StrUtil.format("/{}PageQuery.java", tableInfo.getEntityName()));
        // endregion
        // region 生成GatewayImpl类
        writer(objectMap, templateFilePath(template.getColaGatewayImpl()),
                configBuilder.getPathInfo().get(ConstVal.COLA_GATEWAY_IMPL_PATH) +
                        StrUtil.format("/{}GatewayImpl.java", tableInfo.getEntityName()));
        // endregion
        // region 生成Gateway接口
        writer(objectMap, templateFilePath(template.getColaGateway()),
                configBuilder.getPathInfo().get(ConstVal.COLA_DOMAIN_PATH) +
                        StrUtil.format("/gateway/{}Gateway.java", tableInfo.getEntityName()));
        // endregion

        // region 生成Domain领域类
        writer(objectMap, templateFilePath(template.getColaDomain()),
                configBuilder.getPathInfo().get(ConstVal.COLA_DOMAIN_CHILD_PATH) +
                        StrUtil.format("/{}Entity.java", tableInfo.getEntityName()));
        // endregion

        // region 生成数据库Mapper类
        writer(objectMap, templateFilePath(template.getColaMapper()),
                configBuilder.getPathInfo().get(ConstVal.COLA_MAPPER_PATH) +
                        StrUtil.format("/{}Mapper.java", tableInfo.getEntityName()));
        // endregion

        // region 生成数据库实体类
        writer(objectMap, templateFilePath(template.getColaEntity()),
                configBuilder.getPathInfo().get(ConstVal.COLA_DATA_PROJECT) +
                        StrUtil.format("/{}DB.java", tableInfo.getEntityName()));
        // endregion
    }

    void outPutPomCola(TemplateConfig template, Map<String, Object> objectMap) throws Exception {
        if (!configBuilder.getStrategyConfig().isProjectModel()) {
            return;
        }

        // region 工程POM
        writer(objectMap, templateFilePath(template.getColaProjectPom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/pom.xml"));
        // endregion

        // region adapter工程POM
        writer(objectMap, templateFilePath(template.getColaAdapterPom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/{}-adapter/pom.xml", configBuilder.getGlobalConfig().getProjectName()));
        // endregion

        // region client工程POM
        writer(objectMap, templateFilePath(template.getColaClientPom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/{}-client/pom.xml", configBuilder.getGlobalConfig().getProjectName()));
        // endregion

        // region app工程POM
        writer(objectMap, templateFilePath(template.getColaAppPom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/{}-app/pom.xml", configBuilder.getGlobalConfig().getProjectName()));
        // endregion

        // region domain工程POM
        writer(objectMap, templateFilePath(template.getColaDomainPom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/{}-domain/pom.xml", configBuilder.getGlobalConfig().getProjectName()));
        // endregion

        // region infrastructure工程POM
        writer(objectMap, templateFilePath(template.getColaInfrastructurePom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/{}-infrastructure/pom.xml", configBuilder.getGlobalConfig().getProjectName()));
        // endregion

        // region data工程POM
        writer(objectMap, templateFilePath(template.getColaDataPom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/{}-data/pom.xml", configBuilder.getGlobalConfig().getProjectName()));
        // endregion

        // region start工程POM
        writer(objectMap, templateFilePath(template.getColaStartPom()),
                configBuilder.getPathInfo().get(ConstVal.PROJECT_PATH) +
                        StrUtil.format("/{}-start/pom.xml", configBuilder.getGlobalConfig().getProjectName()));

        // region 生成Start Application类
        writer(objectMap, templateFilePath(template.getColaStart()),
                configBuilder.getPathInfo().get(ConstVal.COLA_START_PROJECT) +
                        StrUtil.format("/{}Application.java", StringUtils.toCamelUpperCase(configBuilder.getGlobalConfig().getProjectName())));
        // endregion

        // endregion
    }
    // endregion



    @Override
    public AbstractTemplateEngine mkdirs() {

        if (ObjectUtil.isNotNull(getConfigBuilder().getPathInfo())) {
            getConfigBuilder().getPathInfo().forEach((key, value) -> {
                File dir = new File(value);
                if (!dir.exists()) {
                    boolean result = dir.mkdirs();
                    if (result) {
                        logger.debug("创建目录： [" + value + "]");
                    }
                } else {
                    logger.debug("目录已经存在：[" + value + "]");
                }
            });
            return this;
        }
        return this;
    }
}
