package cc.xbyter.code.generator.config.rules;

import cn.hutool.core.util.StrUtil;
import cc.xbyter.code.generator.config.GlobalConfig;

public class TypeConverts {
    public static IColumnType convert(GlobalConfig globalConfig, String dbType) {
        if (StrUtil.isEmpty(dbType)) {
            return DbColumnType.STRING;
        }

        dbType = dbType.toLowerCase();
        if (dbType.contains("char") || dbType.contains("text")
                || dbType.contains("json") || dbType.contains("enum")) {
            return DbColumnType.STRING;
        } else if (dbType.contains("bigint")) {
            return DbColumnType.LONG;
        } else if (dbType.contains("tinyint(1)") || dbType.contains("bit")) {
            return DbColumnType.BOOLEAN;
        } else if (dbType.contains("int")) {
            return DbColumnType.INTEGER;
        } else if (dbType.contains("decimal")) {
            return DbColumnType.BIG_DECIMAL;
        } else if (dbType.contains("clob")) {
            return DbColumnType.CLOB;
        } else if (dbType.contains("blob")) {
            return DbColumnType.BLOB;
        } else if (dbType.contains("binary")) {
            return DbColumnType.BYTE_ARRAY;
        } else if (dbType.contains("float")) {
            return DbColumnType.FLOAT;
        } else if (dbType.contains("double")) {
            return DbColumnType.DOUBLE;
        } else if (dbType.contains("date") || dbType.contains("time") || dbType.contains("year")) {
            return toDateType(globalConfig, dbType);
        } else {
            return DbColumnType.STRING;
        }
    }

    public static IColumnType toDateType(GlobalConfig config, String type) {
        switch (config.getDateType()) {
            case ONLY_DATE:
                return DbColumnType.DATE;
            case SQL_PACK:
                switch (type) {
                    case "date":
                    case "year":
                        return DbColumnType.DATE_SQL;
                    case "time":
                        return DbColumnType.TIME;
                    default:
                        return DbColumnType.TIMESTAMP;
                }
            case TIME_PACK:
                switch (type) {
                    case "date":
                        return DbColumnType.LOCAL_DATE;
                    case "time":
                        return DbColumnType.LOCAL_TIME;
                    case "year":
                        return DbColumnType.YEAR;
                    default:
                        return DbColumnType.LOCAL_DATE_TIME;
                }
        }
        return DbColumnType.STRING;
    }

}
