/*
 * Copyright (c) 2011-2020, baomidou (jobob@qq.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package cc.xbyter.code.generator.config;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 模板路径配置项
 *
 * @author tzg hubin
 * @since 2017-06-17
 */
@Data
@Accessors(chain = true)
public class TemplateConfig {

    private String colaEntity = ConstVal.TEMPLATE_COLA_ENTITY_JAVA;
    private String colaMapper = ConstVal.TEMPLATE_COLA_MAPPER_JAVA;
    private String colaDomain = ConstVal.TEMPLATE_COLA_DOMAIN_JAVA;
    private String colaGateway = ConstVal.TEMPLATE_COLA_GATEWAY_JAVA;
    private String colaGatewayImpl = ConstVal.TEMPLATE_COLA_GATEWAY_IMPL_JAVA;
    private String colaPageQuery = ConstVal.TEMPLATE_COLA_PAGE_QUERY_JAVA;
    private String colaEditCmd = ConstVal.TEMPLATE_COLA_EDIT_CMD_JAVA;
    private String colaDetailVO = ConstVal.TEMPLATE_COLA_DETAIL_VO_JAVA;
    private String colaPageItemVO = ConstVal.TEMPLATE_COLA_PAGE_ITEM_VO_JAVA;
    private String colaService = ConstVal.TEMPLATE_COLA_SERVICE_JAVA;
    private String colaServiceImpl = ConstVal.TEMPLATE_COLA_SERVICE_IMPL_JAVA;
    private String colaController = ConstVal.TEMPLATE_COLA_CONTROLLER_JAVA;
    private String colaStart = ConstVal.TEMPLATE_COLA_START_APPLICATION_JAVA;

    private String colaProjectPom = ConstVal.TEMPLATE_COLA_PROJECT_POM;
    private String colaAdapterPom = ConstVal.TEMPLATE_COLA_ADAPTER_POM;
    private String colaAppPom = ConstVal.TEMPLATE_COLA_APP_POM;
    private String colaClientPom = ConstVal.TEMPLATE_COLA_CLIENT_POM;
    private String colaDataPom = ConstVal.TEMPLATE_COLA_DATA_POM;
    private String colaDomainPom = ConstVal.TEMPLATE_COLA_DOMAIN_POM;
    private String colaInfrastructurePom = ConstVal.TEMPLATE_COLA_INFRASTRUCTURE_POM;
    private String colaStartPom = ConstVal.TEMPLATE_COLA_START_POM;


}
