/*
 * Copyright (c) 2011-2023, baomidou (jobob@qq.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cc.xbyter.code.generator.config;

import lombok.Data;
import lombok.Getter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 策略配置项
 *
 * @author YangHu, tangguo, hubin
 * @since 2016/8/30
 */
@Data
@Accessors(chain = true)
public class StrategyConfig {
    @Getter
    private String[] tablePrefix;
    @Getter
    private String[] fieldPrefix;
    @Getter
    private String[] include = null;
    private boolean entityLombokModel = true;
    private boolean chainModel = true;
    /**
     * 是否生成工程
     */
    private boolean projectModel = true;


    public void setTablePrefix(String... tablePrefix) {
        this.tablePrefix = tablePrefix;
    }


    public StrategyConfig setFieldPrefix(String... fieldPrefix) {
        this.fieldPrefix = fieldPrefix;
        return this;
    }

    public StrategyConfig setInclude(String... include) {
        this.include = include;
        return this;
    }

    public List<String> getIncludeList() {
        return include == null ? null : java.util.Arrays.asList(include);
    }
}
