package cc.xbyter.code.generator.config;


import cn.hutool.core.util.StrUtil;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author cc
 */
@Data
@Accessors(chain = true)
public class PackageConfig {
    /**
     * 父包名
     */
    private String parent = "com.linkduoo.brand.goods";

    /**
     * cola adapter controller 包名
     */
    private String colaAdapter = "web";
    private String colaClient = "client";
    private String colaApp = "app";
    private String colaDomain = "domain";
    private String colaGateway = "domain.gateway";
    private String colaGatewayImpl = "infrastructure.gateway.impl";
    private String colaService = "client.api";
    private String colaServiceImpl = "app.service";
    private String colaController = "web";
    private String colaStartApplication = "start";
    private String colaInfrastructure = "infrastructure";
    private String colaData = "data.dataobject";
    private String colaMapper = "infrastructure.gateway.impl.mapper";
    private String colaStart = "infrastructure";
    private String colaPageQuery = "client.dto.query";
    private String colaEditCmd = "client.dto.cmd";
    private String colaDetailVO = "client.dto.data";

    public String getParentPath() {
        return parent.replace(".", "/");
    }

    public String getColaMapperScanPackage() {
        return StrUtil.format(parent, ".", colaMapper);
    }
}
