package cc.xbyter.code.generator.config;

import cc.xbyter.code.generator.config.rules.DateType;
import cc.xbyter.code.generator.config.rules.NamingStrategy;
import cc.xbyter.code.generator.config.rules.ProjectType;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author cc
 */
@Data
@Accessors(chain = true)
public class GlobalConfig {
    /**
     * 输出的文件夹位置
     */
    private String outputDir = "~/work/brand/";
    /**
     * 工程名称前缀
     */
    private String projectName = "brand-goods";
    private String author = "cc";
    /**
     * 生成架构，默认COLA
     */
    private ProjectType projectType = ProjectType.COLA;
    /**
     * 时间类
     */
    private DateType dateType = DateType.TIME_PACK;
    /**
     * 是否加swagger注解
     */
    private boolean swagger = true;
    /**
     * 数据库字端名转属性名规则
     */
    private NamingStrategy columnNaming = NamingStrategy.underline_to_camel;
    /**
     * 表名转Entity类名规则
     */
    private NamingStrategy TableNaming = NamingStrategy.underline_to_camel;
    /**
     * cola架构数据库实体类的父类
     */
    private String colaSuperEntityClass = "com.linkduoo.brand.core.base.dataobject.BaseDB";
    /**
     * cola架构领域类的父类
     */
    private String colaSuperDomainClass = "com.linkduoo.brand.core.base.entity.BaseEntity";
    /**
     * 领域类的包名
     */
    private String domainPackageName = "other";


}
