package cc.xbyter.code.generator.config;

import java.nio.charset.StandardCharsets;

/**
 * @author cc
 */
public interface ConstVal {
    String COLA_ENTITY = "ColaEntity";
    String COLA_MAPPER = "ColaMapper";
    String COLA_DOMAIN = "ColaDomain";
    String COLA_GATEWAY = "ColaGateway";
    String COLA_GATEWAY_IMPL = "ColaGatewayImpl";
    String COLA_PAGE_QUERY = "ColaPageQuery";
    String COLA_EDIT_CMD = "ColaEditCmd";
    String COLA_DETAIL_VO = "ColaDetailVO";
    String COLA_PAGE_ITEM_VO = "ColaPageItemVO";
    String COLA_SERVICE = "ColaService";
    String COLA_SERVICE_IMPL = "ColaServiceImpl";
    String COLA_CONTROLLER = "ColaController";
    String COLA_START_APPLICATION = "ColaStartApplication";
    String PROJECT_NAME = "projectName";
    String PROJECT_PATH = "projectPath";

    // region 需要创建的目录
    String COLA_DOMAIN_PROJECT = "domain_project_path";
    String COLA_ADAPTER_PROJECT = "adapter_project_path";
    String COLA_CLIENT_PROJECT = "client_project_path";
    String COLA_APP_PROJECT = "app_project_path";
    String COLA_INFRASTRUCTURE_PROJECT = "infrastructure_project_path";
    String COLA_DATA_PROJECT = "data_project_path";
    String COLA_START_PROJECT = "start_project_path";
    // endregion

    // region 模版文件路径
    String TEMPLATE_COLA_ENTITY_JAVA = "/templates/entity.java";
    String TEMPLATE_COLA_MAPPER_JAVA = "/templates/mapper.java";
    String TEMPLATE_COLA_DOMAIN_JAVA = "/templates/domain.java";
    String TEMPLATE_COLA_GATEWAY_JAVA = "/templates/gateway.java";
    String TEMPLATE_COLA_GATEWAY_IMPL_JAVA = "/templates/gateway_impl.java";
    String TEMPLATE_COLA_PAGE_QUERY_JAVA = "/templates/page_query.java";
    String TEMPLATE_COLA_EDIT_CMD_JAVA = "/templates/edit_cmd.java";
    String TEMPLATE_COLA_DETAIL_VO_JAVA = "/templates/detail_vo.java";
    String TEMPLATE_COLA_PAGE_ITEM_VO_JAVA = "/templates/page_item_vo.java";
    String TEMPLATE_COLA_SERVICE_JAVA = "/templates/cola_service.java";
    String TEMPLATE_COLA_SERVICE_IMPL_JAVA = "/templates/cola_service_impl.java";
    String TEMPLATE_COLA_CONTROLLER_JAVA = "/templates/cola_controller.java";
    String TEMPLATE_COLA_START_APPLICATION_JAVA = "/templates/cola_start_application.java";

    String TEMPLATE_COLA_PROJECT_POM = "templates/project-pom.xml.vm";
    String TEMPLATE_COLA_ADAPTER_POM = "templates/adapter-project-pom.xml.vm";
    String TEMPLATE_COLA_APP_POM = "templates/app-project-pom.xml.vm";
    String TEMPLATE_COLA_CLIENT_POM = "templates/client-project-pom.xml.vm";
    String TEMPLATE_COLA_DOMAIN_POM = "templates/domain-project-pom.xml.vm";
    String TEMPLATE_COLA_INFRASTRUCTURE_POM = "templates/infrastructure-project-pom.xml.vm";
    String TEMPLATE_COLA_DATA_POM = "templates/data-project-pom.xml.vm";
    String TEMPLATE_COLA_START_POM = "templates/start-project-pom.xml.vm";
    // endregion

    String COLA_DOMAIN_PATH = "domain_path";
    String COLA_DOMAIN_CHILD_PATH = "domain_child_path";
    String COLA_CONTROLLER_PATH = "controller_path";
    String COLA_GATEWAY_PATH = "gateway_path";
    String COLA_GATEWAY_IMPL_PATH = "gateway_impl_path";
    String COLA_MAPPER_PATH = "mapper_path";
    String COLA_DATA_OBJECT_PATH = "data_object_path";
    String COLA_SERVICE_PATH = "service_path";
    String COLA_SERVICE_IMPL_PATH = "service_impl_path";
    String COLA_DTO_QUERY_PATH = "dto_query_path";
    String COLA_DTO_CMD_PATH = "dto_cmd_path";
    String COLA_DTO_DETAIL_VO_PATH = "dto_detail_vo_path";

    String MAIN_PATH = "/src/main/java/";

    /**
     * 实体模板路径(kotlin模板)
     */
    String TEMPLATE_ENTITY_KT = "/templates/entity.kt";

    String UTF8 = StandardCharsets.UTF_8.name();
    String UNDERLINE = "_";
    String VM_LOAD_PATH_KEY = "file.resource.loader.class";
    String VM_LOAD_PATH_VALUE = "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader";

}
