package cc.xbyter.code.generator;

import cc.xbyter.code.generator.config.*;
import cc.xbyter.code.generator.config.builder.ConfigBuilder;
import cc.xbyter.code.generator.engine.AbstractTemplateEngine;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author cc
 */
@Data
@Accessors(chain = true)
public class AutoGenerator {
    private ConfigBuilder config;
    private PackageConfig packageInfo;
    private GlobalConfig globalConfig;
    private StrategyConfig strategyConfig;
    private DataSourceConfig dataSourceConfig;
    private TemplateConfig templateConfig;
    private AbstractTemplateEngine templateEngine;

    public void execute() throws Exception {
        config = new ConfigBuilder(packageInfo, globalConfig, strategyConfig, dataSourceConfig, templateConfig);
        templateEngine.init(config).mkdirs().batchOutPut();
    }
}
