/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util.text;

import aws.smithy.kotlin.runtime.util.InternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0007\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\bH\u0007\u001a\"\u0010\u0010\u001a\u00020\b*\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\u0013\u001a\u00020\b*\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007\u001a\"\u0010\u0015\u001a\u00020\b*\u00020\b2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0017H\u0007\u001a\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0007\u001a\u001e\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0 0\u001f*\u00020\bH\u0007\u001a\"\u0010!\u001a\u00020\b*\u00020\b2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0017H\u0007\u001a\u0016\u0010\"\u001a\u00020\b*\u00020\b2\b\b\u0002\u0010#\u001a\u00020\u000bH\u0007\u001a\u0016\u0010$\u001a\u00020\b*\u00020\b2\b\b\u0002\u0010%\u001a\u00020\u000bH\u0007\u001a \u0010&\u001a\u00020\b*\u00020\b2\b\b\u0002\u0010#\u001a\u00020\u000b2\b\b\u0002\u0010%\u001a\u00020\u000bH\u0007\"\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"VALID_PCHAR_DELIMS", "", "", "getVALID_PCHAR_DELIMS$annotations", "()V", "getVALID_PCHAR_DELIMS", "()Ljava/util/Set;", "upperHex", "", "upperHexSet", "isPercentEncodedAt", "", "d", "", "i", "", "encodeUrlPath", "validDelimiters", "checkPercentEncoded", "ensureSuffix", "suffix", "normalizePathSegments", "segmentTransform", "Lkotlin/Function1;", "percentEncodeTo", "", "", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "splitAsQueryString", "", "", "transformPathSegments", "urlDecodeComponent", "formUrlDecode", "urlEncodeComponent", "formUrlEncode", "urlReencodeComponent", "utils"})
public final class TextKt {
    @NotNull
    private static final Set<Character> VALID_PCHAR_DELIMS;
    @NotNull
    private static final String upperHex = "0123456789ABCDEF";
    @NotNull
    private static final Set<Character> upperHexSet;

    @InternalApi
    @NotNull
    public static final String urlEncodeComponent(@NotNull String $this$urlEncodeComponent, boolean formUrlEncode) {
        Intrinsics.checkNotNullParameter((Object)$this$urlEncodeComponent, (String)"<this>");
        StringBuilder sb = new StringBuilder($this$urlEncodeComponent.length());
        for (byte cbyte : StringsKt.encodeToByteArray((String)$this$urlEncodeComponent)) {
            char chr = (char)cbyte;
            char c = chr;
            if (c == ' ') {
                if (formUrlEncode) {
                    sb.append("+");
                    continue;
                }
                sb.append("%20");
                continue;
            }
            boolean bl = (('a' <= c ? c < '{' : false) ? true : ('A' <= c ? c < '[' : false)) ? true : ('0' <= c ? c < ':' : false);
            if ((((bl ? true : c == '-') ? true : c == '_') ? true : c == '.') ? true : c == '~') {
                sb.append(chr);
                continue;
            }
            TextKt.percentEncodeTo(cbyte, sb);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String urlEncodeComponent$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return TextKt.urlEncodeComponent(string, bl);
    }

    @NotNull
    public static final Set<Character> getVALID_PCHAR_DELIMS() {
        return VALID_PCHAR_DELIMS;
    }

    @InternalApi
    public static /* synthetic */ void getVALID_PCHAR_DELIMS$annotations() {
    }

    private static final boolean isPercentEncodedAt(byte[] d, int i) {
        return i + 2 < d.length && (char)d[i] == '%' && i + 2 < d.length && upperHexSet.contains(Character.valueOf(Character.toUpperCase((char)d[i + 1]))) && upperHexSet.contains(Character.valueOf(Character.toUpperCase((char)d[i + 2])));
    }

    @InternalApi
    @NotNull
    public static final String encodeUrlPath(@NotNull String $this$encodeUrlPath) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUrlPath, (String)"<this>");
        return TextKt.encodeUrlPath($this$encodeUrlPath, VALID_PCHAR_DELIMS, true);
    }

    @InternalApi
    @NotNull
    public static final String encodeUrlPath(@NotNull String $this$encodeUrlPath, @NotNull Set<Character> validDelimiters, boolean checkPercentEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUrlPath, (String)"<this>");
        Intrinsics.checkNotNullParameter(validDelimiters, (String)"validDelimiters");
        StringBuilder sb = new StringBuilder($this$encodeUrlPath.length());
        byte[] data = StringsKt.encodeToByteArray((String)$this$encodeUrlPath);
        int i = 0;
        while (i < data.length) {
            if (checkPercentEncoded && TextKt.isPercentEncodedAt(data, i)) {
                sb.append((char)data[i++]);
                sb.append((char)data[i++]);
                sb.append((char)data[i++]);
                continue;
            }
            byte cbyte = data[i];
            char chr = (char)cbyte;
            boolean bl = (('a' <= chr ? chr < '{' : false) ? true : ('A' <= chr ? chr < '[' : false)) ? true : ('0' <= chr ? chr < ':' : false);
            if (bl ? true : validDelimiters.contains(Character.valueOf(chr))) {
                sb.append(chr);
            } else {
                TextKt.percentEncodeTo(cbyte, sb);
            }
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    @NotNull
    public static final String normalizePathSegments(@NotNull String $this$normalizePathSegments, @Nullable Function1<? super String, String> segmentTransform) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$normalizePathSegments, (String)"<this>");
        String[] stringArray = new String[]{"/"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)$this$normalizePathSegments, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)p0).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List segments = (List)destination$iv$iv;
        int skip = 0;
        Iterable $this$normalizePathSegments_u24lambda_u2d1 = iterable = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)segments);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it, (Object)".")) continue;
            if (Intrinsics.areEqual((Object)it, (Object)"..")) {
                ++skip;
                continue;
            }
            if (skip > 0) {
                skip += -1;
                continue;
            }
            $this$normalizePathSegments_u24lambda_u2d1.add(it);
        }
        List normalizedSegments = CollectionsKt.asReversed((List)CollectionsKt.build((List)iterable));
        if (!(skip == 0)) {
            boolean bl3 = false;
            String string = "Found too many `..` instances for path segment count";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.joinToString$default((Iterable)normalizedSegments, (CharSequence)"/", (CharSequence)"/", (CharSequence)(!((Collection)normalizedSegments).isEmpty() && StringsKt.endsWith$default((String)$this$normalizePathSegments, (String)"/", (boolean)false, (int)2, null) ? "/" : ""), (int)0, null, segmentTransform, (int)24, null);
    }

    @InternalApi
    @NotNull
    public static final String transformPathSegments(@NotNull String $this$transformPathSegments, @Nullable Function1<? super String, String> segmentTransform) {
        Intrinsics.checkNotNullParameter((Object)$this$transformPathSegments, (String)"<this>");
        String[] stringArray = new String[]{"/"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$transformPathSegments, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, segmentTransform, (int)30, null);
    }

    @InternalApi
    public static final void percentEncodeTo(byte $this$percentEncodeTo, @NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int code = $this$percentEncodeTo & 0xFF;
        out.append('%');
        out.append(upperHex.charAt(code >> 4));
        out.append(upperHex.charAt(code & 0xF));
    }

    @InternalApi
    @NotNull
    public static final Map<String, List<String>> splitAsQueryString(@NotNull String $this$splitAsQueryString) {
        Intrinsics.checkNotNullParameter((Object)$this$splitAsQueryString, (String)"<this>");
        Map entries = new LinkedHashMap();
        String[] stringArray = new String[]{"&"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)$this$splitAsQueryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            String pair = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List parts = StringsKt.split$default((CharSequence)pair, (String[])stringArray2, (boolean)false, (int)2, (int)2, null);
            String key = (String)parts.get(0);
            switch (parts.size()) {
                case 1: {
                    string = "";
                    break;
                }
                case 2: {
                    string = (String)parts.get(1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid query string: " + parts);
                }
            }
            String value = string;
            if (entries.containsKey(key)) {
                Object v = entries.get(key);
                Intrinsics.checkNotNull(v);
                ((List)v).add(value);
                continue;
            }
            Map map = entries;
            Object object = new String[]{value};
            object = CollectionsKt.mutableListOf((Object[])object);
            map.put(key, object);
        }
        return entries;
    }

    @InternalApi
    @NotNull
    public static final String urlDecodeComponent(@NotNull String $this$urlDecodeComponent, boolean formUrlDecode) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$urlDecodeComponent, (String)"<this>");
        String orig = $this$urlDecodeComponent;
        int n = orig.length();
        StringBuilder $this$urlDecodeComponent_u24lambda_u2d4 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        byte[] byteBuffer = null;
        int i = 0;
        char c = '\u0000';
        while (i < orig.length()) {
            c = orig.charAt(i);
            if (c == '+' && formUrlDecode) {
                $this$urlDecodeComponent_u24lambda_u2d4.append(' ');
                ++i;
                continue;
            }
            if (c == '%') {
                if (byteBuffer == null) {
                    byteBuffer = new byte[(orig.length() - i) / 3];
                }
                int byteCount = 0;
                while (i + 2 < orig.length() && c == '%') {
                    String string = orig.substring(i + 1, i + 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Integer n2 = StringsKt.toIntOrNull((String)string, (int)16);
                    if (n2 == null) {
                        break;
                    }
                    byte by = (byte)n2.intValue();
                    byteBuffer[byteCount++] = by;
                    if ((i += 3) >= orig.length()) continue;
                    c = orig.charAt(i);
                }
                $this$urlDecodeComponent_u24lambda_u2d4.append(StringsKt.decodeToString$default((byte[])byteBuffer, (int)0, (int)byteCount, (boolean)false, (int)5, null));
                if (i == orig.length() || c != '%') continue;
                $this$urlDecodeComponent_u24lambda_u2d4.append(c);
                ++i;
                continue;
            }
            $this$urlDecodeComponent_u24lambda_u2d4.append(c);
            ++i;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String urlDecodeComponent$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return TextKt.urlDecodeComponent(string, bl);
    }

    @InternalApi
    @NotNull
    public static final String urlReencodeComponent(@NotNull String $this$urlReencodeComponent, boolean formUrlDecode, boolean formUrlEncode) {
        Intrinsics.checkNotNullParameter((Object)$this$urlReencodeComponent, (String)"<this>");
        return TextKt.urlEncodeComponent(TextKt.urlDecodeComponent($this$urlReencodeComponent, formUrlDecode), formUrlEncode);
    }

    public static /* synthetic */ String urlReencodeComponent$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return TextKt.urlReencodeComponent(string, bl, bl2);
    }

    @InternalApi
    @NotNull
    public static final String ensureSuffix(@NotNull String $this$ensureSuffix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureSuffix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return StringsKt.endsWith$default((String)$this$ensureSuffix, (String)suffix, (boolean)false, (int)2, null) ? $this$ensureSuffix : $this$ensureSuffix + suffix;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        VALID_PCHAR_DELIMS = SetsKt.setOf((Object[])objectArray);
        upperHexSet = StringsKt.toSet((CharSequence)upperHex);
    }
}

