/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util.net;

import aws.smithy.kotlin.runtime.util.InternalApi;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\b\u001a\u0014\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\u0005H\u0007\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u0005H\u0007\u001a\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0005H\u0002\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\u0005H\u0002\u001a\f\u0010\r\u001a\u00020\u0007*\u00020\u0005H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0007*\u00020\u0005H\u0007\u001a\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"ipv6DualSegmentCount", "", "ipv6StandardSegmentCount", "getIpv6AddressSegments", "", "", "isHexDigit", "", "", "isIpv4", "isIpv6", "isIpv6Address", "isIpv6AddressSegment", "isIpv6ScopeId", "isValidHostname", "isValidPercentEncoded", "utils"})
public final class TextKt {
    private static final int ipv6StandardSegmentCount = 8;
    private static final int ipv6DualSegmentCount = 7;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalApi
    public static final boolean isValidHostname(@NotNull String $this$isValidHostname) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidHostname, (String)"<this>");
        int n = $this$isValidHostname.length();
        if (1 > n) return false;
        if (n >= 64) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Character.isLetterOrDigit($this$isValidHostname.charAt(0))) return false;
        CharSequence $this$all$iv = StringsKt.drop((String)$this$isValidHostname, (int)1);
        boolean $i$f$all = false;
        int n2 = 0;
        while (n2 < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n2);
            boolean bl2 = false;
            if (!Character.isLetterOrDigit(it)) {
                if (it != '-') return false;
            }
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalApi
    public static final boolean isIpv4(@NotNull String $this$isIpv4) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isIpv4, (String)"<this>");
        char[] cArray = new char[]{'.'};
        List segments = StringsKt.split$default((CharSequence)$this$isIpv4, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (segments.size() != 4) return false;
        Iterable $this$all$iv = segments;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            Integer n = StringsKt.toIntOrNull((String)it);
            if (n == null) return false;
            int n2 = n;
            int n3 = n2;
            if (0 > n3) return false;
            if (n3 >= 256) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @InternalApi
    public static final boolean isIpv6(@NotNull String $this$isIpv6) {
        Intrinsics.checkNotNullParameter((Object)$this$isIpv6, (String)"<this>");
        char[] cArray = new char[]{'%'};
        List components = StringsKt.split$default((CharSequence)$this$isIpv6, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (components.size() > 2) {
            return false;
        }
        if (components.size() == 2 && !TextKt.isIpv6ScopeId((String)components.get(1))) {
            return false;
        }
        return TextKt.isIpv6Address((String)components.get(0));
    }

    private static final List<String> getIpv6AddressSegments(String $this$getIpv6AddressSegments) {
        List list;
        List list2;
        List leftSegments;
        List list3;
        String[] stringArray = new String[]{"::"};
        List explicitSegmentGroups = StringsKt.split$default((CharSequence)$this$getIpv6AddressSegments, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (explicitSegmentGroups.size() > 2) {
            return null;
        }
        if (explicitSegmentGroups.size() == 1) {
            stringArray = new String[]{":"};
            return StringsKt.split$default((CharSequence)((CharSequence)explicitSegmentGroups.get(0)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        if (Intrinsics.areEqual(explicitSegmentGroups.get(0), (Object)"")) {
            list3 = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{':'};
            list3 = leftSegments = StringsKt.split$default((CharSequence)((CharSequence)explicitSegmentGroups.get(0)), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        if (Intrinsics.areEqual(explicitSegmentGroups.get(1), (Object)"")) {
            list2 = CollectionsKt.emptyList();
        } else {
            char[] cArray = new char[]{':'};
            list2 = StringsKt.split$default((CharSequence)((CharSequence)explicitSegmentGroups.get(1)), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }
        List rightSegments = list2;
        String string = (String)CollectionsKt.lastOrNull((List)rightSegments);
        int totalSegmentCount = (string != null ? StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null) : false) ? 7 : 8;
        int implicitSegmentCount = totalSegmentCount - leftSegments.size() - rightSegments.size();
        List $this$getIpv6AddressSegments_u24lambda_u2d3 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getIpv6AddressSegments_u24lambda_u2d3.addAll(leftSegments);
        int n = 0;
        while (n < implicitSegmentCount) {
            int it = n++;
            boolean bl2 = false;
            $this$getIpv6AddressSegments_u24lambda_u2d3.add("0");
        }
        $this$getIpv6AddressSegments_u24lambda_u2d3.addAll(rightSegments);
        return CollectionsKt.build((List)list);
    }

    private static final boolean isIpv6Address(String $this$isIpv6Address) {
        List<String> list = TextKt.getIpv6AddressSegments($this$isIpv6Address);
        if (list == null) {
            return false;
        }
        List<String> segments = list;
        if (segments.size() < 7) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (TextKt.isIpv6AddressSegment(segments.get(i))) continue;
            return false;
        }
        if (segments.size() == 7) {
            return TextKt.isIpv4(segments.get(6));
        }
        if (segments.size() != 8) {
            return false;
        }
        return TextKt.isIpv6AddressSegment(segments.get(6)) && TextKt.isIpv6AddressSegment(segments.get(7));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIpv6AddressSegment(String $this$isIpv6AddressSegment) {
        int n = $this$isIpv6AddressSegment.length();
        if (1 > n) return false;
        if (n >= 5) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = $this$isIpv6AddressSegment;
        boolean $i$f$all = false;
        int n2 = 0;
        while (n2 < $this$all$iv.length()) {
            char element$iv;
            char p0 = element$iv = $this$all$iv.charAt(n2);
            boolean bl2 = false;
            if (!TextKt.isHexDigit(p0)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final boolean isIpv6ScopeId(String $this$isIpv6ScopeId) {
        return ((CharSequence)$this$isIpv6ScopeId).length() > 0 && !StringsKt.contains$default((CharSequence)$this$isIpv6ScopeId, (char)'%', (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isValidPercentEncoded(String $this$isValidPercentEncoded) {
        CharSequence $this$forEachIndexed$iv = $this$isValidPercentEncoded;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            void var9_9 = char_;
            if (((((((97 <= var9_9 ? var9_9 < 123 : false) ? true : (65 <= var9_9 ? var9_9 < 91 : false)) ? true : (48 <= var9_9 ? var9_9 < 58 : false)) ? true : var9_9 == 45) ? true : var9_9 == 95) ? true : var9_9 == 46) ? true : var9_9 == 126) continue;
            if (var9_9 == 37) {
                if (index > $this$isValidPercentEncoded.length() - 2) {
                    return false;
                }
                if (TextKt.isHexDigit($this$isValidPercentEncoded.charAt(index + 1)) && TextKt.isHexDigit($this$isValidPercentEncoded.charAt(index + 2))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isHexDigit(char $this$isHexDigit) {
        boolean bl;
        boolean bl2;
        if ('0' <= $this$isHexDigit) {
            if ($this$isHexDigit < ':') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('a' <= $this$isHexDigit) {
            if ($this$isHexDigit < 'g') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('A' > $this$isHexDigit) return false;
        if ($this$isHexDigit >= 'G') return false;
        return true;
    }
}

