/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util.net;

import aws.smithy.kotlin.runtime.util.net.Host;
import aws.smithy.kotlin.runtime.util.net.TextKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0003*\u00020\u0001\u00a8\u0006\u0005"}, d2={"hostParseImpl", "Laws/smithy/kotlin/runtime/util/net/Host;", "host", "", "toUrlString", "utils"})
public final class HostKt {
    private static final Host hostParseImpl(String host) {
        Host host2;
        if (TextKt.isIpv4(host)) {
            host2 = new Host.IPv4(host);
        } else if (TextKt.isIpv6(host)) {
            char[] cArray = new char[]{'%'};
            List components = StringsKt.split$default((CharSequence)host, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            host2 = new Host.IPv6((String)components.get(0), components.size() > 1 ? (String)components.get(1) : null);
        } else {
            boolean bl;
            block9: {
                char[] components = new char[]{'.'};
                Iterable $this$all$iv = StringsKt.split$default((CharSequence)host, (char[])components, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String p0 = (String)element$iv;
                        boolean bl2 = false;
                        if (TextKt.isValidHostname(p0)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                host2 = new Host.Domain(host);
            } else {
                throw new IllegalArgumentException(host + " is not a valid inet host");
            }
        }
        return host2;
    }

    @NotNull
    public static final String toUrlString(@NotNull Host $this$toUrlString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toUrlString, (String)"<this>");
        Host host = $this$toUrlString;
        if (host instanceof Host.IPv4) {
            string = ((Host.IPv4)$this$toUrlString).getAddress();
        } else if (host instanceof Host.IPv6) {
            string = ((Host.IPv6)$this$toUrlString).getScopeId() == null ? '[' + ((Host.IPv6)$this$toUrlString).getAddress() + ']' : '[' + ((Host.IPv6)$this$toUrlString).getAddress() + "%25" + aws.smithy.kotlin.runtime.util.text.TextKt.urlEncodeComponent$default(((Host.IPv6)$this$toUrlString).getScopeId(), false, 1, null) + ']';
        } else if (host instanceof Host.Domain) {
            string = ((Host.Domain)$this$toUrlString).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ Host access$hostParseImpl(String host) {
        return HostKt.hostParseImpl(host);
    }
}

