/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import kotlin.Metadata;
import kotlin.RequiresOptIn;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/util/Uuid;", "", "high", "", "low", "(JJ)V", "getHigh", "()J", "getLow", "stringRep", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "WeakRng", "utils"})
public final class Uuid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long high;
    private final long low;
    @NotNull
    private final String stringRep;
    @NotNull
    private static final char[] nibbleChars;
    @NotNull
    private static final Random.Default random;
    private static final long v4Mask;
    private static final long v4Set;
    private static final long type2Mask;
    private static final long type2Set;

    public Uuid(long high, long low) {
        this.high = high;
        this.low = low;
        this.stringRep = Uuid.Companion.toString(this.high, this.low);
    }

    public final long getHigh() {
        return this.high;
    }

    public final long getLow() {
        return this.low;
    }

    @NotNull
    public String toString() {
        return this.stringRep;
    }

    public final long component1() {
        return this.high;
    }

    public final long component2() {
        return this.low;
    }

    @NotNull
    public final Uuid copy(long high, long low) {
        return new Uuid(high, low);
    }

    public static /* synthetic */ Uuid copy$default(Uuid uuid, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = uuid.high;
        }
        if ((n & 2) != 0) {
            l2 = uuid.low;
        }
        return uuid.copy(l, l2);
    }

    public int hashCode() {
        int result = Long.hashCode(this.high);
        result = result * 31 + Long.hashCode(this.low);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uuid)) {
            return false;
        }
        Uuid uuid = (Uuid)other;
        if (this.high != uuid.high) {
            return false;
        }
        return this.low == uuid.low;
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        nibbleChars = cArray;
        random = Random.Default;
        v4Mask = (long)61440 & 0xFFFFFFFFL;
        v4Set = (long)16384 & 0xFFFFFFFFL;
        type2Mask = -4611686018427387904L;
        type2Set = Long.MIN_VALUE;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/util/Uuid$Companion;", "", "()V", "nibbleChars", "", "random", "Lkotlin/random/Random$Default;", "type2Mask", "", "type2Set", "v4Mask", "v4Set", "Laws/smithy/kotlin/runtime/util/Uuid;", "toString", "", "high", "low", "writeDigits", "", "src", "srcOffset", "", "dest", "destOffset", "length", "utils"})
    public static final class Companion {
        private Companion() {
        }

        @WeakRng
        @NotNull
        public final Uuid random() {
            long high = random.nextLong() & (v4Mask ^ 0xFFFFFFFFFFFFFFFFL) | v4Set;
            long low = random.nextLong() & (type2Mask ^ 0xFFFFFFFFFFFFFFFFL) | type2Set;
            return new Uuid(high, low);
        }

        private final String toString(long high, long low) {
            char[] chars = new char[36];
            this.writeDigits(high, 0, chars, 0, 4);
            chars[8] = 45;
            this.writeDigits(high, 4, chars, 9, 2);
            chars[13] = 45;
            this.writeDigits(high, 6, chars, 14, 2);
            chars[18] = 45;
            this.writeDigits(low, 0, chars, 19, 2);
            chars[23] = 45;
            this.writeDigits(low, 2, chars, 24, 6);
            return StringsKt.concatToString((char[])chars);
        }

        private final void writeDigits(long src, int srcOffset, char[] dest, int destOffset, int length) {
            int shiftBits = 0;
            shiftBits = 64 - srcOffset * 8;
            int destIndex = 0;
            destIndex = destOffset;
            int n = length * 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                long nibble = src >> (shiftBits -= 4) & 0xFL;
                int n3 = destIndex;
                destIndex = n3 + 1;
                dest[n3] = nibbleChars[(int)nibble];
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.annotation.Retention(value=AnnotationRetention.BINARY)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.FUNCTION})
    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.METHOD})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Laws/smithy/kotlin/runtime/util/Uuid$WeakRng;", "", "utils"})
    @RequiresOptIn(message="This API doesn't use cryptographically-strong random number generation.")
    public static @interface WeakRng {
    }
}

