/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.util;

import aws.smithy.kotlin.runtime.util.OperatingSystem;
import aws.smithy.kotlin.runtime.util.Platform;
import aws.smithy.kotlin.runtime.util.PlatformJVMKt;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012H\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!R\u001b\u0010\u0003\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\b\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\r\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Laws/smithy/kotlin/runtime/util/Platform;", "Laws/smithy/kotlin/runtime/util/PlatformProvider;", "()V", "filePathSeparator", "", "getFilePathSeparator", "()Ljava/lang/String;", "filePathSeparator$delegate", "Lkotlin/Lazy;", "isAndroid", "", "()Z", "isAndroid$delegate", "isBrowser", "isJvm", "isNative", "isNode", "getAllEnvVars", "", "getAllProperties", "getProperty", "key", "getenv", "osInfo", "Laws/smithy/kotlin/runtime/util/OperatingSystem;", "readFileOrNull", "", "file", "Ljava/io/File;", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "utils"})
public final class Platform
implements PlatformProvider {
    @NotNull
    public static final Platform INSTANCE = new Platform();
    private static final boolean isJvm = true;
    @NotNull
    private static final Lazy isAndroid$delegate = LazyKt.lazy((Function0)isAndroid.2.INSTANCE);
    private static final boolean isBrowser;
    private static final boolean isNode;
    private static final boolean isNative;
    @NotNull
    private static final Lazy filePathSeparator$delegate;

    private Platform() {
    }

    @Override
    @NotNull
    public Map<String, String> getAllEnvVars() {
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
        return map;
    }

    @Override
    @Nullable
    public String getenv(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return System.getenv().get(key);
    }

    public final boolean isJvm() {
        return isJvm;
    }

    public final boolean isAndroid() {
        Lazy lazy = isAndroid$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isBrowser() {
        return isBrowser;
    }

    public final boolean isNode() {
        return isNode;
    }

    public final boolean isNative() {
        return isNative;
    }

    @Override
    @NotNull
    public OperatingSystem osInfo() {
        return PlatformJVMKt.access$getOsInfo();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object readFileOrNull(@NotNull String var1_1, @NotNull Continuation<? super byte[]> var2_2) {
        if (!(var2_2 instanceof readFileOrNull.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ Platform this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.readFileOrNull((String)null, (Continuation<? super byte[]>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>((String)path, null){
                    int label;
                    final /* synthetic */ String $path;
                    {
                        this.$path = $path;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return FilesKt.readBytes((File)new File(this.$path));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super byte[]> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var7_5) goto lbl18
lbl17:
                // 1 sources

                return var7_5;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    var3_6 = (byte[])v0;
                }
                catch (IOException var4_7) {
                    var3_6 = null;
                }
                return var3_6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object readFileOrNull(@NotNull Path path, @NotNull Continuation<? super byte[]> $completion) {
        return this.readFileOrNull(((Object)path.toAbsolutePath()).toString(), $completion);
    }

    @Nullable
    public final Object readFileOrNull(@NotNull File file, @NotNull Continuation<? super byte[]> $completion) {
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        return this.readFileOrNull(string, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getAllProperties() {
        void $this$associateTo$iv$iv;
        Set<Map.Entry<Object, Object>> set = System.getProperties().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getProperties()\n        .entries");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
            Object key = entry.getKey();
            Object value = entry.getValue();
            entry = TuplesKt.to((Object)key.toString(), (Object)value.toString());
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return System.getProperty(key);
    }

    @Override
    @NotNull
    public String getFilePathSeparator() {
        Lazy lazy = filePathSeparator$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-filePathSeparator>(...)");
        return (String)object;
    }

    static {
        filePathSeparator$delegate = LazyKt.lazy((Function0)filePathSeparator.2.INSTANCE);
    }
}

