/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.tracing;

import aws.smithy.kotlin.runtime.logging.Logger;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.tracing.EventLevel;
import aws.smithy.kotlin.runtime.tracing.TraceEvent;
import aws.smithy.kotlin.runtime.tracing.TraceEventData;
import aws.smithy.kotlin.runtime.tracing.TraceSpan;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\"\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\"\u0010\u000e\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\"\u0010\u000f\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J*\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\r2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ\u0018\u0010\u0014\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\"\u0010\u0014\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\"\u0010\u0015\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/tracing/TraceSpanLogger;", "Laws/smithy/kotlin/runtime/logging/Logger;", "span", "Laws/smithy/kotlin/runtime/tracing/TraceSpan;", "sourceComponent", "", "(Laws/smithy/kotlin/runtime/tracing/TraceSpan;Ljava/lang/String;)V", "debug", "", "msg", "Lkotlin/Function0;", "", "t", "", "error", "info", "log", "level", "Laws/smithy/kotlin/runtime/tracing/EventLevel;", "ex", "trace", "warn", "tracing-core"})
final class TraceSpanLogger
implements Logger {
    @NotNull
    private final TraceSpan span;
    @NotNull
    private final String sourceComponent;

    public TraceSpanLogger(@NotNull TraceSpan span, @NotNull String sourceComponent) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Intrinsics.checkNotNullParameter((Object)sourceComponent, (String)"sourceComponent");
        this.span = span;
        this.sourceComponent = sourceComponent;
    }

    public final void log(@NotNull EventLevel level, @Nullable Throwable ex, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        TraceEvent event = new TraceEvent(level, this.sourceComponent, Instant.Companion.now(), "thread-id", new TraceEventData.Message(ex, msg));
        this.span.postEvent(event);
    }

    public static /* synthetic */ void log$default(TraceSpanLogger traceSpanLogger, EventLevel eventLevel, Throwable throwable, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        traceSpanLogger.log(eventLevel, throwable, (Function0<? extends Object>)function0);
    }

    public void error(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Error, null, msg);
    }

    public void error(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Error, t, msg);
    }

    public void warn(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Warning, null, msg);
    }

    public void warn(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Warning, t, msg);
    }

    public void info(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Info, null, msg);
    }

    public void info(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Info, t, msg);
    }

    public void debug(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Debug, null, msg);
    }

    public void debug(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Debug, t, msg);
    }

    public void trace(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Trace, null, msg);
    }

    public void trace(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.log(EventLevel.Trace, t, msg);
    }
}

