/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.tracing;

import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.tracing.EventLevel;
import aws.smithy.kotlin.runtime.tracing.TraceEventData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Laws/smithy/kotlin/runtime/tracing/TraceEvent;", "", "level", "Laws/smithy/kotlin/runtime/tracing/EventLevel;", "sourceComponent", "", "timestamp", "Laws/smithy/kotlin/runtime/time/Instant;", "threadId", "data", "Laws/smithy/kotlin/runtime/tracing/TraceEventData;", "(Laws/smithy/kotlin/runtime/tracing/EventLevel;Ljava/lang/String;Laws/smithy/kotlin/runtime/time/Instant;Ljava/lang/String;Laws/smithy/kotlin/runtime/tracing/TraceEventData;)V", "getData", "()Laws/smithy/kotlin/runtime/tracing/TraceEventData;", "getLevel", "()Laws/smithy/kotlin/runtime/tracing/EventLevel;", "getSourceComponent", "()Ljava/lang/String;", "getThreadId", "getTimestamp", "()Laws/smithy/kotlin/runtime/time/Instant;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "tracing-core"})
public final class TraceEvent {
    @NotNull
    private final EventLevel level;
    @NotNull
    private final String sourceComponent;
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final String threadId;
    @NotNull
    private final TraceEventData data;

    public TraceEvent(@NotNull EventLevel level, @NotNull String sourceComponent, @NotNull Instant timestamp, @NotNull String threadId, @NotNull TraceEventData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)sourceComponent, (String)"sourceComponent");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.level = level;
        this.sourceComponent = sourceComponent;
        this.timestamp = timestamp;
        this.threadId = threadId;
        this.data = data;
    }

    @NotNull
    public final EventLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final String getSourceComponent() {
        return this.sourceComponent;
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final String getThreadId() {
        return this.threadId;
    }

    @NotNull
    public final TraceEventData getData() {
        return this.data;
    }

    @NotNull
    public final EventLevel component1() {
        return this.level;
    }

    @NotNull
    public final String component2() {
        return this.sourceComponent;
    }

    @NotNull
    public final Instant component3() {
        return this.timestamp;
    }

    @NotNull
    public final String component4() {
        return this.threadId;
    }

    @NotNull
    public final TraceEventData component5() {
        return this.data;
    }

    @NotNull
    public final TraceEvent copy(@NotNull EventLevel level, @NotNull String sourceComponent, @NotNull Instant timestamp, @NotNull String threadId, @NotNull TraceEventData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)sourceComponent, (String)"sourceComponent");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new TraceEvent(level, sourceComponent, timestamp, threadId, data);
    }

    public static /* synthetic */ TraceEvent copy$default(TraceEvent traceEvent, EventLevel eventLevel, String string, Instant instant, String string2, TraceEventData traceEventData, int n, Object object) {
        if ((n & 1) != 0) {
            eventLevel = traceEvent.level;
        }
        if ((n & 2) != 0) {
            string = traceEvent.sourceComponent;
        }
        if ((n & 4) != 0) {
            instant = traceEvent.timestamp;
        }
        if ((n & 8) != 0) {
            string2 = traceEvent.threadId;
        }
        if ((n & 0x10) != 0) {
            traceEventData = traceEvent.data;
        }
        return traceEvent.copy(eventLevel, string, instant, string2, traceEventData);
    }

    @NotNull
    public String toString() {
        return "TraceEvent(level=" + (Object)((Object)this.level) + ", sourceComponent=" + this.sourceComponent + ", timestamp=" + this.timestamp + ", threadId=" + this.threadId + ", data=" + this.data + ')';
    }

    public int hashCode() {
        int result = this.level.hashCode();
        result = result * 31 + this.sourceComponent.hashCode();
        result = result * 31 + this.timestamp.hashCode();
        result = result * 31 + this.threadId.hashCode();
        result = result * 31 + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TraceEvent)) {
            return false;
        }
        TraceEvent traceEvent = (TraceEvent)other;
        if (this.level != traceEvent.level) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceComponent, (Object)traceEvent.sourceComponent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timestamp, (Object)traceEvent.timestamp)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.threadId, (Object)traceEvent.threadId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.data, (Object)traceEvent.data);
    }
}

