/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.tracing;

import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbeKt;
import aws.smithy.kotlin.runtime.tracing.TraceEvent;
import aws.smithy.kotlin.runtime.tracing.TraceEventData;
import aws.smithy.kotlin.runtime.tracing.TraceProbe;
import aws.smithy.kotlin.runtime.tracing.TraceSpan;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Laws/smithy/kotlin/runtime/tracing/LoggingTraceProbe;", "Laws/smithy/kotlin/runtime/tracing/TraceProbe;", "()V", "log", "", "spanId", "", "event", "Laws/smithy/kotlin/runtime/tracing/TraceEvent;", "message", "Laws/smithy/kotlin/runtime/tracing/TraceEventData$Message;", "postEvent", "span", "Laws/smithy/kotlin/runtime/tracing/TraceSpan;", "spanClosed", "tracing-core"})
public final class LoggingTraceProbe
implements TraceProbe {
    @NotNull
    public static final LoggingTraceProbe INSTANCE = new LoggingTraceProbe();

    private LoggingTraceProbe() {
    }

    private final void log(String spanId, TraceEvent event, TraceEventData.Message message) {
        KLogger logger = KotlinLogging.INSTANCE.logger(event.getSourceComponent());
        if (message.getException() == null) {
            LoggingTraceProbeKt.access$loggerMethod(event.getLevel()).invoke((Object)logger, (Object)new Function0<Object>(spanId, message){
                final /* synthetic */ String $spanId;
                final /* synthetic */ TraceEventData.Message $message;
                {
                    this.$spanId = $spanId;
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$spanId + ": " + this.$message.getContent().invoke();
                }
            });
        } else {
            LoggingTraceProbeKt.access$throwableLoggerMethod(event.getLevel()).invoke((Object)logger, (Object)message.getException(), (Object)new Function0<Object>(spanId, message){
                final /* synthetic */ String $spanId;
                final /* synthetic */ TraceEventData.Message $message;
                {
                    this.$spanId = $spanId;
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$spanId + ": " + this.$message.getContent().invoke();
                }
            });
        }
    }

    @Override
    public void postEvent(@NotNull TraceSpan span, @NotNull TraceEvent event) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getData() instanceof TraceEventData.Message) {
            this.log(LoggingTraceProbeKt.access$getHierarchicalId(span), event, (TraceEventData.Message)event.getData());
        }
    }

    @Override
    public void spanClosed(@NotNull TraceSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
    }
}

