/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.testing;

import aws.smithy.kotlin.runtime.testing.RandomInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u000b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/testing/RandomTempFile;", "Ljava/io/File;", "sizeInBytes", "", "filename", "", "binaryData", "", "(JLjava/lang/String;Z)V", "createFile", "", "delete", "Companion", "testing"})
public final class RandomTempFile
extends File {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean binaryData;
    @NotNull
    private static final String TEMP_DIR;

    public RandomTempFile(long sizeInBytes, @NotNull String filename, boolean binaryData) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        super(TEMP_DIR + File.separator + System.currentTimeMillis() + '-' + filename);
        this.binaryData = binaryData;
        this.createFile(sizeInBytes);
    }

    public /* synthetic */ RandomTempFile(long l, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            string = string2;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(l, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createFile(long sizeInBytes) throws IOException {
        this.deleteOnExit();
        Closeable closeable = new FileOutputStream(this);
        Throwable throwable = null;
        try {
            long l;
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new BufferedOutputStream(outputStream);
            Throwable throwable2 = null;
            try {
                long l2;
                BufferedOutputStream bufferedOutputStream = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new RandomInputStream(sizeInBytes, this.binaryData);
                Throwable throwable3 = null;
                try {
                    RandomInputStream inputStream = (RandomInputStream)closeable3;
                    boolean bl3 = false;
                    l2 = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)bufferedOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                l = l2;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l3 = l;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public boolean delete() {
        if (!super.delete()) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Could not delete: ", (Object)this.getAbsolutePath()));
        }
        return true;
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.io.tmpdir\")");
        TEMP_DIR = string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Laws/smithy/kotlin/runtime/testing/RandomTempFile$Companion;", "", "()V", "TEMP_DIR", "", "testing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

